/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.beans;

import com.github.paganini2008.devtools.ObjectUtils;
import com.github.paganini2008.devtools.beans.BeanPropertyAccessException;
import com.github.paganini2008.devtools.beans.PropertyFilter;
import com.github.paganini2008.devtools.beans.PropertyUtils;
import com.github.paganini2008.devtools.collection.MapUtils;
import com.github.paganini2008.devtools.reflection.MethodUtils;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;

public abstract class EqualsBuilder {
    public static boolean reflectionEquals(Object source, Object target) {
        return EqualsBuilder.reflectionEquals(source, target, (PropertyFilter)null);
    }

    public static boolean reflectionEquals(Object source, Object target, PropertyFilter filter) {
        return EqualsBuilder.reflectionEquals(source, target, null, filter);
    }

    public static boolean reflectionEquals(Object source, Object target, Class<?> stopClass, PropertyFilter filter) {
        if (source == target) {
            return true;
        }
        if (source == null || target == null) {
            return false;
        }
        if (source.getClass() != target.getClass()) {
            return false;
        }
        Map<String, PropertyDescriptor> descriptors = PropertyUtils.getPropertyDescriptors(source.getClass(), stopClass, filter);
        if (MapUtils.isEmpty(descriptors)) {
            return source.equals(target);
        }
        return EqualsBuilder.reflectionEquals(source, target, descriptors.values());
    }

    private static boolean reflectionEquals(Object source, Object target, Collection<PropertyDescriptor> descriptors) {
        for (PropertyDescriptor descriptor : descriptors) {
            Object right;
            Object left;
            Method method = descriptor.getReadMethod();
            if (method == null || !ObjectUtils.notEquals(left = EqualsBuilder.invokeMethod(source, method), right = EqualsBuilder.invokeMethod(target, method))) continue;
            return false;
        }
        return true;
    }

    private static Object invokeMethod(Object object, Method method) {
        try {
            return MethodUtils.invokeMethod(object, method, new Object[0]);
        }
        catch (Exception e) {
            throw new BeanPropertyAccessException(e.getMessage(), e);
        }
    }
}

