/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.beans;

import com.github.paganini2008.devtools.ArrayUtils;
import com.github.paganini2008.devtools.ClassUtils;
import com.github.paganini2008.devtools.MatchMode;
import com.github.paganini2008.devtools.beans.PropertyFilter;
import com.github.paganini2008.devtools.reflection.FieldUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;

public abstract class PropertyFilters {
    public static PropertyFilter isAnnotationPresent(Class<? extends Annotation>[] annotationClasses) {
        return (type, name, descriptor) -> {
            Field field = FieldUtils.getFieldIfAbsent(type, name);
            if (field == null) {
                return false;
            }
            for (Class annotationClass : annotationClasses) {
                if (!field.isAnnotationPresent(annotationClass)) continue;
                return true;
            }
            return false;
        };
    }

    public static PropertyFilter isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return (type, name, descriptor) -> {
            Field field = FieldUtils.getFieldIfAbsent(type, name);
            return field != null && field.isAnnotationPresent(annotationClass);
        };
    }

    public static PropertyFilter isAssignable(Class<?>[] requiredTypes) {
        return (type, name, descriptor) -> ClassUtils.isAssignable(requiredTypes, descriptor.getPropertyType());
    }

    public static <T> PropertyFilter isAssignable(Class<T> requiredType) {
        return (type, name, descriptor) -> ClassUtils.isAssignable(requiredType, descriptor.getPropertyType());
    }

    public static PropertyFilter includedProperties(String[] propertyNames) {
        return (type, name, descriptor) -> ArrayUtils.contains(propertyNames, name);
    }

    public static PropertyFilter excludedProperties(String[] propertyNames) {
        return (type, name, descriptor) -> ArrayUtils.notContains(propertyNames, name);
    }

    public static PropertyFilter matches(String substr, MatchMode matchMode) {
        return (type, name, descriptor) -> matchMode.matches(name, substr);
    }

    public static PropertyFilter propertyTypeContains(Class<?>[] optional) {
        return (type, name, descriptor) -> ArrayUtils.contains(optional, descriptor.getPropertyType());
    }
}

