/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.cache;

import com.github.paganini2008.devtools.cache.Cache;
import com.github.paganini2008.devtools.cache.CheckedExpiredCache;
import com.github.paganini2008.devtools.cache.ExpiredCache;
import com.github.paganini2008.devtools.cache.MasterStandbyCache;
import com.github.paganini2008.devtools.cache.UncheckedExpiredCache;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public abstract class AbstractCache
implements Cache {
    public Cache masterStandbyCache(Cache backup) {
        return new MasterStandbyCache(this, backup);
    }

    public ExpiredCache expiredCache(int interval, TimeUnit timeUnit) {
        if (this instanceof CheckedExpiredCache) {
            throw new UnsupportedOperationException();
        }
        return new CheckedExpiredCache(this, interval, timeUnit);
    }

    public ExpiredCache expiredCache() {
        if (this instanceof ExpiredCache) {
            throw new UnsupportedOperationException();
        }
        return new UncheckedExpiredCache(this);
    }

    @Override
    public Iterator<Object> iterator() {
        return new CacheIterator(this);
    }

    @Override
    public Map<Object, Object> toEntries() {
        LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>();
        for (Object key : this.keys()) {
            map.put(key, this.getObject(key));
        }
        return map;
    }

    private static class CacheIterator
    implements Iterator<Object> {
        private final Cache delegate;
        private final Iterator<Object> it;
        private Object key;

        CacheIterator(Cache delegate) {
            this.delegate = delegate;
            this.it = delegate.keys().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public Object next() {
            this.key = this.it.next();
            return this.delegate.getObject(this.key);
        }

        @Override
        public void remove() {
            this.delegate.removeObject(this.key);
        }
    }
}

