/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.cache;

import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;

public interface Cache
extends Iterable<Object> {
    default public void putObject(Object key, Object value) {
        this.putObject(key, value, false);
    }

    public void putObject(Object var1, Object var2, boolean var3);

    public boolean hasKey(Object var1);

    public Object getObject(Object var1);

    default public Object getObject(Object key, Object defaultValue) {
        return this.getObject(key, () -> defaultValue);
    }

    default public Object getObject(Object key, Supplier<Object> defaultValue) {
        Object o = this.getObject(key);
        if (o == null) {
            this.putObject(key, defaultValue.get());
            o = this.getObject(key);
        }
        return o;
    }

    public Object removeObject(Object var1);

    public Set<Object> keys();

    public Map<Object, Object> toEntries();

    public void clear();

    public int getSize();

    default public void close() {
    }
}

