/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.cache;

import com.github.paganini2008.devtools.cache.BoundedCache;
import com.github.paganini2008.devtools.cache.CacheStore;
import com.github.paganini2008.devtools.collection.ConcurrentBoundedMap;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class FifoCache
extends BoundedCache {
    private final ConcurrentBoundedMap<Object, Object> boundedMap;
    private CacheStore store;

    public FifoCache(int maxSize) {
        this.boundedMap = new ConcurrentBoundedMap<Object, Object>(new ConcurrentHashMap(), maxSize){
            private static final long serialVersionUID = 1L;

            @Override
            public void onEviction(Object eldestKey, Object eldestValue) {
                if (FifoCache.this.store != null) {
                    FifoCache.this.store.writeObject(eldestKey, eldestValue);
                } else {
                    FifoCache.this.dispose(eldestKey, eldestValue);
                }
            }
        };
    }

    @Override
    public void setCacheStore(CacheStore store) {
        this.store = store;
    }

    @Override
    public int getSize() {
        return this.boundedMap.size() + (this.store != null ? this.store.getSize() : 0);
    }

    @Override
    public void putObject(Object key, Object value, boolean ifAbsent) {
        if (ifAbsent) {
            this.boundedMap.putIfAbsent(key, value);
        } else {
            this.boundedMap.put(key, value);
        }
    }

    @Override
    public Object getObject(Object key) {
        Object result = this.boundedMap.get(key);
        if (result == null && this.store != null && (result = this.store.readObject(key)) != null) {
            this.store.removeObject(key);
            this.putObject(key, result);
        }
        return result;
    }

    @Override
    public Object removeObject(Object key) {
        Object result = this.boundedMap.remove(key);
        if (result == null && this.store != null) {
            result = this.store.removeObject(key);
        }
        if (result != null) {
            this.dispose(key, result);
        }
        return result;
    }

    @Override
    public void clear() {
        this.boundedMap.clear();
    }

    @Override
    public Set<Object> keys() {
        HashSet<Object> keys = new HashSet<Object>();
        keys.addAll(this.boundedMap.keySet());
        if (this.store != null) {
            keys.addAll(this.store.keys());
        }
        return Collections.unmodifiableSet(keys);
    }

    @Override
    public boolean hasKey(Object key) {
        return this.boundedMap.containsKey(key) || this.store != null && this.store.hasKey(key);
    }

    public String toString() {
        return this.boundedMap.toString();
    }
}

