/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.cache;

import com.github.paganini2008.devtools.cache.BoundedCache;
import com.github.paganini2008.devtools.cache.CacheStore;
import com.github.paganini2008.devtools.collection.LruMap;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class LruCache
extends BoundedCache {
    private final LruMap<Object, Object> lruMap;
    private CacheStore store;

    public LruCache(int maxSize) {
        this.lruMap = new LruMap<Object, Object>(new ConcurrentHashMap(), maxSize){
            private static final long serialVersionUID = 1L;

            @Override
            public void onEviction(Object eldestKey, Object eldestValue) {
                if (LruCache.this.store != null) {
                    LruCache.this.store.writeObject(eldestKey, eldestValue);
                } else {
                    LruCache.this.dispose(eldestKey, eldestValue);
                }
            }
        };
    }

    protected LruCache(LruMap<Object, Object> lruMap) {
        this.lruMap = lruMap;
    }

    @Override
    public void setCacheStore(CacheStore store) {
        this.store = store;
    }

    @Override
    public void putObject(Object key, Object value, boolean ifAbsent) {
        if (ifAbsent) {
            this.lruMap.putIfAbsent(key, value);
        } else {
            this.lruMap.put(key, value);
        }
    }

    @Override
    public Object getObject(Object key) {
        Object result = this.lruMap.get(key);
        if (result == null && this.store != null && (result = this.store.readObject(key)) != null && this.store.removeObject(key) != null) {
            this.putObject(key, result);
        }
        return result;
    }

    @Override
    public Object removeObject(Object key) {
        Object result = this.lruMap.remove(key);
        if (result == null && this.store != null) {
            result = this.store.removeObject(key);
        }
        if (result != null) {
            this.dispose(key, result);
        }
        return result;
    }

    @Override
    public int getSize() {
        return this.lruMap.size() + (this.store != null ? this.store.getSize() : 0);
    }

    @Override
    public Set<Object> keys() {
        HashSet<Object> keys = new HashSet<Object>();
        keys.addAll(this.lruMap.keySet());
        if (this.store != null) {
            keys.addAll(this.store.keys());
        }
        return Collections.unmodifiableSet(keys);
    }

    @Override
    public void clear() {
        this.lruMap.clear();
    }

    @Override
    public boolean hasKey(Object key) {
        return this.lruMap.containsKey(key) || this.store != null && this.store.hasKey(key);
    }

    public String toString() {
        return this.lruMap.toString();
    }
}

