/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.collection;

import com.github.paganini2008.devtools.ObjectUtils;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicStampedReference;
import java.util.function.BiFunction;
import java.util.stream.Collectors;

public abstract class AtomicMutableMap<K, V>
extends AbstractMap<K, V>
implements Map<K, V>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected final Map<K, AtomicStampedReference<V>> delegate;

    protected AtomicMutableMap(Map<K, AtomicStampedReference<V>> delegate) {
        this.delegate = delegate;
    }

    @Override
    public V get(Object key) {
        AtomicStampedReference<V> ref = this.delegate.get(this.mutate(key));
        return ref != null ? (V)ref.getReference() : null;
    }

    @Override
    public V put(K key, V value) {
        AtomicStampedReference<V> prev = this.delegate.put(this.mutate(key), new AtomicStampedReference<V>(value, 0));
        return prev != null ? (V)prev.getReference() : null;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.delegate.containsKey(this.mutate(key));
    }

    @Override
    public boolean containsValue(Object value) {
        for (AtomicStampedReference<V> ref : this.delegate.values()) {
            if (!ObjectUtils.equals(ref.getReference(), value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public V remove(Object key) {
        AtomicStampedReference<V> prev = this.delegate.remove(this.mutate(key));
        return prev != null ? (V)prev.getReference() : null;
    }

    @Override
    public Set<K> keySet() {
        return this.delegate.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.delegate.values().stream().map(ref -> ref.getReference()).collect(Collectors.toList());
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    public Map<K, V> toMap() {
        return this.delegate.entrySet().stream().collect(Collectors.toMap(e -> e.getKey(), e -> ((AtomicStampedReference)e.getValue()).getReference(), (o, n) -> o, LinkedHashMap::new));
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.toMap().entrySet();
    }

    @Override
    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> fun) {
        AtomicStampedReference<V> ref = this.delegate.get(key = this.mutate(key));
        if (ref == null) {
            this.delegate.putIfAbsent(key, new AtomicStampedReference<Object>(null, 0));
            ref = this.delegate.get(key);
        }
        if (ref != null) {
            V update;
            V current;
            while (!ref.compareAndSet(current = ref.getReference(), update = fun.apply(current, value), ref.getStamp(), ref.getStamp() + 1)) {
            }
            return update;
        }
        return null;
    }

    protected K mutate(Object key) {
        return (K)key;
    }
}

