/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.collection;

import com.github.paganini2008.devtools.ObjectUtils;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicStampedReference;

public class AtomicReferenceMap<K, V>
extends AbstractMap<K, V>
implements Map<K, V>,
Serializable {
    private static final long serialVersionUID = 4925536519828538578L;
    private final Map<K, AtomicStampedReference<V>> delegate;

    public AtomicReferenceMap() {
        this(false);
    }

    public AtomicReferenceMap(boolean ordered) {
        this(ordered ? new ConcurrentSkipListMap() : new ConcurrentHashMap());
    }

    public AtomicReferenceMap(Map<K, AtomicStampedReference<V>> delegate) {
        this.delegate = delegate;
    }

    @Override
    public V putIfAbsent(K key, V value) {
        V update;
        V current;
        AtomicStampedReference<V> ref = this.delegate.get(key);
        if (ref == null) {
            this.delegate.putIfAbsent(key, new AtomicStampedReference<Object>(null, 0));
            ref = this.delegate.get(key);
        }
        while (!ref.compareAndSet(current = ref.getReference(), update = this.merge(key, current, value), ref.getStamp(), ref.getStamp() + 1)) {
        }
        return update;
    }

    @Override
    public V put(K key, V value) {
        AtomicStampedReference<V> eldest = this.delegate.put(key, new AtomicStampedReference<V>(value, 0));
        return eldest != null ? (V)eldest.getReference() : null;
    }

    protected V merge(K key, V current, V value) {
        return value;
    }

    @Override
    public V get(Object key) {
        AtomicStampedReference<V> ref = this.delegate.get(key);
        return ref != null ? (V)ref.getReference() : null;
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.delegate.keySet();
    }

    @Override
    public Collection<V> values() {
        ArrayList<V> values = new ArrayList<V>();
        for (AtomicStampedReference<V> ref : this.delegate.values()) {
            values.add(ref.getReference());
        }
        return values;
    }

    @Override
    public V remove(Object key) {
        AtomicStampedReference<V> ref = this.delegate.remove(key);
        return ref != null ? (V)ref.getReference() : null;
    }

    @Override
    public boolean containsValue(Object value) {
        for (AtomicStampedReference<V> ref : this.delegate.values()) {
            if (!ObjectUtils.equals(ref.getReference(), value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    public Map<K, V> toMap() {
        HashMap<K, V> map = new HashMap<K, V>();
        for (Map.Entry<K, AtomicStampedReference<V>> entry : this.delegate.entrySet()) {
            map.put(entry.getKey(), entry.getValue().getReference());
        }
        return map;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.toMap().entrySet();
    }

    @Override
    public String toString() {
        return this.toMap().toString();
    }
}

