/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.collection;

import com.github.paganini2008.devtools.collection.BoundedCollection;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Collection;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;

public class ConcurrentBoundedList<E>
extends AbstractList<E>
implements Serializable,
BoundedCollection<E> {
    private static final long serialVersionUID = 4364094168351330996L;
    private final List<E> delegate;
    private final int maxSize;
    private final Queue<E> keys;

    public ConcurrentBoundedList(int maxSize) {
        this(new CopyOnWriteArrayList(), maxSize);
    }

    public ConcurrentBoundedList(List<E> delegate, int maxSize) {
        this(delegate, maxSize, new ConcurrentLinkedQueue());
    }

    public ConcurrentBoundedList(List<E> delegate, int maxSize, Queue<E> keys) {
        this.delegate = delegate;
        this.maxSize = maxSize;
        this.keys = keys;
    }

    @Override
    public boolean add(E e) {
        boolean result = this.delegate.add(e);
        this.ensureCapacity(e);
        return result;
    }

    @Override
    public E set(int index, E element) {
        E previous = this.delegate.set(index, element);
        if (previous != null) {
            this.keys.remove(previous);
        }
        this.ensureCapacity(element);
        return previous;
    }

    @Override
    public void add(int index, E element) {
        this.delegate.add(index, element);
        this.ensureCapacity(element);
    }

    @Override
    public boolean contains(Object o) {
        return this.delegate.contains(o);
    }

    @Override
    public boolean remove(Object o) {
        if (this.delegate.remove(o)) {
            this.keys.remove(o);
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.delegate.containsAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        if (this.delegate.removeAll(c)) {
            this.keys.removeAll(c);
            return true;
        }
        return false;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        if (this.delegate.retainAll(c)) {
            this.keys.retainAll(c);
            return true;
        }
        return false;
    }

    @Override
    public E remove(int index) {
        E previous = this.delegate.remove(index);
        this.keys.remove(previous);
        return previous;
    }

    @Override
    public int indexOf(Object o) {
        return this.delegate.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.delegate.lastIndexOf(o);
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        return this.delegate.subList(fromIndex, toIndex);
    }

    @Override
    public E get(int index) {
        return this.delegate.get(index);
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public Collection<E> getDelegate() {
        return this.delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureCapacity(E e) {
        boolean reached;
        Object eldestElement = null;
        Queue<E> queue = this.keys;
        synchronized (queue) {
            this.keys.add(e);
            reached = this.keys.size() > this.maxSize;
            if (reached) {
                eldestElement = this.keys.poll();
                this.delegate.remove(eldestElement);
            }
        }
        if (reached) {
            this.onEviction(eldestElement);
        }
    }
}

