/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.collection;

import com.github.paganini2008.devtools.collection.BoundedMap;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;

public class ConcurrentBoundedMap<K, V>
extends AbstractMap<K, V>
implements Map<K, V>,
Serializable,
BoundedMap<K, V> {
    private static final long serialVersionUID = -4746340195536492722L;
    private final Queue<K> keys;
    private final int maxSize;
    private final Map<K, V> delegate;

    public ConcurrentBoundedMap(int maxSize) {
        this(new ConcurrentHashMap(), maxSize);
    }

    public ConcurrentBoundedMap(Map<K, V> delegate, int maxSize) {
        this(delegate, maxSize, new ConcurrentLinkedQueue());
    }

    protected ConcurrentBoundedMap(Map<K, V> delegate, int maxSize, Queue<K> keys) {
        this.delegate = delegate;
        this.maxSize = maxSize;
        this.keys = keys;
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean containsValue(Object value) {
        return this.delegate.containsValue(value);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public V get(Object key) {
        return this.delegate.get(key);
    }

    @Override
    public V put(K key, V value) {
        V eldestValue = this.delegate.put(key, value);
        this.ensureCapacity(key);
        return eldestValue;
    }

    @Override
    public V putIfAbsent(K key, V value) {
        V eldestValue = this.delegate.putIfAbsent(key, value);
        this.ensureCapacity(key);
        return eldestValue;
    }

    @Override
    public V remove(Object key) {
        this.keys.remove(key);
        return this.delegate.remove(key);
    }

    @Override
    public void clear() {
        this.keys.clear();
        this.delegate.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.delegate.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.delegate.values();
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.delegate.entrySet();
    }

    @Override
    public int getMaxSize() {
        return this.maxSize;
    }

    @Override
    public Map<K, V> getDelegate() {
        return this.delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureCapacity(K key) {
        boolean reached;
        Object eldestKey = null;
        Object eldestValue = null;
        Queue<K> queue = this.keys;
        synchronized (queue) {
            if (!this.keys.contains(key)) {
                this.keys.add(key);
            }
            if (reached = this.keys.size() > this.maxSize) {
                eldestKey = this.keys.poll();
                eldestValue = this.delegate.remove(eldestKey);
            }
        }
        if (reached) {
            this.onEviction(eldestKey, eldestValue);
        }
    }
}

