/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.collection;

import com.github.paganini2008.devtools.collection.BoundedCollection;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Collection;
import java.util.List;
import java.util.NavigableSet;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArrayList;

public class ConcurrentSortedBoundedList<E>
extends AbstractList<E>
implements Serializable,
BoundedCollection<E> {
    private static final long serialVersionUID = -4261600807536071807L;
    private final List<E> delegate;
    private final int maxSize;
    private final NavigableSet<E> keys;
    private boolean asc = true;

    public ConcurrentSortedBoundedList(int maxSize) {
        this(new CopyOnWriteArrayList(), maxSize);
    }

    public ConcurrentSortedBoundedList(List<E> delegate, int maxSize) {
        this(delegate, maxSize, new ConcurrentSkipListSet());
    }

    protected ConcurrentSortedBoundedList(List<E> delegate, int maxSize, NavigableSet<E> keys) {
        this.delegate = delegate;
        this.maxSize = maxSize;
        this.keys = keys;
    }

    public void setAsc(boolean asc) {
        this.asc = asc;
    }

    @Override
    public boolean add(E e) {
        boolean result = this.delegate.add(e);
        return result && this.ensureCapacity(e);
    }

    @Override
    public E set(int index, E element) {
        E previous = this.delegate.set(index, element);
        if (previous != null) {
            this.keys.remove(previous);
        }
        this.ensureCapacity(element);
        return previous;
    }

    @Override
    public void add(int index, E element) {
        this.delegate.add(index, element);
        this.ensureCapacity(element);
    }

    @Override
    public boolean contains(Object o) {
        return this.delegate.contains(o);
    }

    @Override
    public boolean remove(Object o) {
        if (this.delegate.remove(o)) {
            this.keys.remove(o);
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.delegate.containsAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        if (this.delegate.removeAll(c)) {
            this.keys.removeAll(c);
            return true;
        }
        return false;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        if (this.delegate.retainAll(c)) {
            this.keys.retainAll(c);
            return true;
        }
        return false;
    }

    @Override
    public E remove(int index) {
        E previous = this.delegate.remove(index);
        this.keys.remove(previous);
        return previous;
    }

    @Override
    public int indexOf(Object o) {
        return this.delegate.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.delegate.lastIndexOf(o);
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        return this.delegate.subList(fromIndex, toIndex);
    }

    @Override
    public E get(int index) {
        return this.delegate.get(index);
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public Collection<E> getDelegate() {
        return this.delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean ensureCapacity(E e) {
        boolean reached = false;
        Object eldestElement = null;
        NavigableSet<E> navigableSet = this.keys;
        synchronized (navigableSet) {
            boolean a = this.keys.add(e);
            if (a) {
                reached = this.keys.size() > this.maxSize;
                if (reached) {
                    eldestElement = this.asc ? this.keys.pollFirst() : this.keys.pollLast();
                    this.delegate.remove(eldestElement);
                }
            } else {
                this.delegate.remove(e);
            }
        }
        if (reached) {
            this.onEviction(eldestElement);
        }
        return reached;
    }
}

