/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.collection;

import com.github.paganini2008.devtools.MissingKeyException;
import com.github.paganini2008.devtools.primitives.Booleans;
import com.github.paganini2008.devtools.primitives.Bytes;
import com.github.paganini2008.devtools.primitives.Chars;
import com.github.paganini2008.devtools.primitives.Doubles;
import com.github.paganini2008.devtools.primitives.Floats;
import com.github.paganini2008.devtools.primitives.Ints;
import com.github.paganini2008.devtools.primitives.Longs;
import com.github.paganini2008.devtools.primitives.Shorts;
import java.util.Properties;

public class DataConverterProperties
extends Properties {
    private static final long serialVersionUID = -891559340734908695L;

    public Boolean getRequiredBoolean(String name) {
        this.assertKeyExisted(name);
        return Booleans.valueOf(this.getProperty(name));
    }

    public Character getRequiredCharacter(String name) {
        this.assertKeyExisted(name);
        return Chars.valueOf(this.getProperty(name));
    }

    public Byte getRequiredByte(String name) {
        this.assertKeyExisted(name);
        return Bytes.valueOf(this.getProperty(name));
    }

    public Short getRequiredShort(String name) {
        this.assertKeyExisted(name);
        return Shorts.valueOf(this.getProperty(name));
    }

    public Integer getRequiredInteger(String name) {
        this.assertKeyExisted(name);
        return Ints.valueOf(this.getProperty(name));
    }

    public Float getRequiredFloat(String name) {
        this.assertKeyExisted(name);
        return Floats.valueOf(this.getProperty(name));
    }

    public Double getRequiredDouble(String name) {
        this.assertKeyExisted(name);
        return Doubles.valueOf(this.getProperty(name));
    }

    public Long getRequiredLong(String name) {
        this.assertKeyExisted(name);
        return Longs.valueOf(this.getProperty(name));
    }

    private void assertKeyExisted(String name) {
        if (!this.containsKey(name)) {
            throw new MissingKeyException(name);
        }
    }

    public Boolean getBoolean(String name, Boolean defaultValue) {
        return Booleans.valueOf(this.getProperty(name), defaultValue);
    }

    public Character getCharacter(String name, Character defaultValue) {
        return Chars.valueOf(this.getProperty(name), defaultValue);
    }

    public Byte getByte(String name, Byte defaultValue) {
        return Bytes.valueOf(this.getProperty(name), defaultValue);
    }

    public Short getShort(String name, Short defaultValue) {
        return Shorts.valueOf(this.getProperty(name), defaultValue);
    }

    public Integer getInteger(String name, Integer defaultValue) {
        return Ints.valueOf(this.getProperty(name), defaultValue);
    }

    public Float getFloat(String name, Float defaultValue) {
        return Floats.valueOf(this.getProperty(name), defaultValue);
    }

    public Double getDouble(String name, Double defaultValue) {
        return Doubles.valueOf(this.getProperty(name), defaultValue);
    }

    public Long getLong(String name, Long defaultValue) {
        return Longs.valueOf(this.getProperty(name), defaultValue);
    }
}

