/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.collection;

import com.github.paganini2008.devtools.collection.MapUtils;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Set;

public abstract class KeyConversionMap<T, K, V>
extends AbstractMap<K, V>
implements Map<K, V>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<K, V> delegate;
    private final Map<T, K> keys;

    protected KeyConversionMap(Map<K, V> delegate) {
        this.delegate = delegate;
        this.keys = MapUtils.synchronizedHashMap();
    }

    @Override
    public boolean containsKey(Object key) {
        K realKey = this.keys.get(this.convertKey(key));
        return this.delegate.containsKey(realKey);
    }

    @Override
    public V get(Object key) {
        K realKey = this.keys.get(this.convertKey(key));
        return realKey != null ? (V)this.delegate.get(realKey) : null;
    }

    @Override
    public V put(K key, V value) {
        this.keys.put(this.convertKey(key), key);
        return this.delegate.put(key, value);
    }

    @Override
    public V remove(Object key) {
        K realKey = this.keys.remove(this.convertKey(key));
        return realKey != null ? (V)this.delegate.remove(realKey) : null;
    }

    @Override
    public void clear() {
        this.keys.clear();
        this.delegate.clear();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.delegate.entrySet();
    }

    protected abstract T convertKey(Object var1);
}

