/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.collection;

import com.github.paganini2008.devtools.RandomUtils;
import com.github.paganini2008.devtools.collection.BoundedCollection;
import com.github.paganini2008.devtools.collection.LruMapSupplier;
import com.github.paganini2008.devtools.collection.MapUtils;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;

public class LruList<E>
extends AbstractList<E>
implements List<E>,
Serializable,
BoundedCollection<E> {
    private static final long serialVersionUID = -216068975490011223L;
    private final List<E> delegate;
    private final Map<Integer, E> keys;
    private int index = 0;
    private static final Map<Integer, AtomicInteger> counter = new ConcurrentHashMap<Integer, AtomicInteger>();

    public LruList() {
        this(128);
    }

    public LruList(int maxSize) {
        this(new CopyOnWriteArrayList(), maxSize);
    }

    public LruList(int maxSize, LruMapSupplier<Integer, E> supplier) {
        this(new CopyOnWriteArrayList(), maxSize, supplier);
    }

    public LruList(List<E> delegate, int maxSize) {
        this(delegate, maxSize, (size, listener) -> MapUtils.synchronizedLinkedHashMap(16, size, listener));
    }

    public LruList(List<E> delegate, int maxSize, LruMapSupplier<Integer, E> supplier) {
        this.delegate = delegate;
        this.keys = supplier.get(maxSize, (key, value) -> {
            delegate.remove(value);
            this.onEviction(value);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(E e) {
        Map<Integer, E> map = this.keys;
        synchronized (map) {
            this.keys.put(this.index++, e);
            return this.delegate.add(e);
        }
    }

    @Override
    public boolean contains(Object o) {
        if (this.delegate.contains(o)) {
            this.keys.get(this.delegate.indexOf(o));
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        this.delegate.clear();
        this.keys.clear();
    }

    @Override
    public Iterator<E> iterator() {
        return this.delegate.iterator();
    }

    @Override
    public boolean remove(Object o) {
        if (this.delegate.remove(o)) {
            this.keys.remove(this.delegate.indexOf(o));
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public E get(int index) {
        E e = this.delegate.get(index);
        if (e != null) {
            this.keys.get(index);
        }
        return e;
    }

    @Override
    public void add(int index, E e) {
        this.delegate.add(index, e);
        this.keys.put(index, e);
    }

    @Override
    public E set(int index, E e) {
        E previous = this.delegate.set(index, e);
        this.keys.put(index, e);
        return previous;
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return this.delegate.listIterator(index);
    }

    @Override
    public Collection<E> getDelegate() {
        return this.delegate;
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    public static void main(String[] args) {
        LruList<Integer> list = new LruList<Integer>(20);
        for (int i = 0; i < 10000; ++i) {
            int value = RandomUtils.randomInt(1, 20);
            list.add(value);
            MapUtils.get(counter, Integer.valueOf(value), () -> new AtomicInteger(0)).incrementAndGet();
        }
        System.out.println(list);
        System.out.println("-------------------------------------");
        System.out.println(counter);
    }
}

