/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.collection;

import com.github.paganini2008.devtools.collection.BoundedCollection;
import com.github.paganini2008.devtools.collection.LruMapSupplier;
import com.github.paganini2008.devtools.collection.MapUtils;
import java.io.Serializable;
import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class LruQueue<E>
extends AbstractQueue<E>
implements Queue<E>,
Serializable,
BoundedCollection<E> {
    private static final long serialVersionUID = -6416314527516614700L;
    private final Queue<E> delegate;
    private final Map<Integer, E> keys;
    private int index = 0;

    public LruQueue() {
        this(128);
    }

    public LruQueue(int maxSize) {
        this(new ConcurrentLinkedQueue(), maxSize);
    }

    public LruQueue(int maxSize, LruMapSupplier<Integer, E> supplier) {
        this(new ConcurrentLinkedQueue(), maxSize, supplier);
    }

    public LruQueue(Queue<E> delegate, int maxSize) {
        this(delegate, maxSize, (size, listener) -> MapUtils.synchronizedLinkedHashMap(16, size, listener));
    }

    public LruQueue(Queue<E> delegate, int maxSize, LruMapSupplier<Integer, E> supplier) {
        this.delegate = delegate;
        this.keys = supplier.get(maxSize, (key, value) -> {
            delegate.remove(value);
            this.onEviction(value);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(E e) {
        Map<Integer, E> map = this.keys;
        synchronized (map) {
            this.keys.put(this.index++, e);
            return this.delegate.offer(e);
        }
    }

    @Override
    public E poll() {
        E e = this.delegate.poll();
        if (e != null) {
            MapUtils.removeLastEntry(this.keys);
        }
        return e;
    }

    @Override
    public E peek() {
        E e = this.delegate.peek();
        if (e != null) {
            this.keys.get(MapUtils.getLastEntry(this.keys).getKey());
        }
        return e;
    }

    @Override
    public boolean contains(Object o) {
        if (this.delegate.contains(o)) {
            this.keys.get(this.indexFor(o));
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(Object o) {
        if (this.delegate.remove(o)) {
            this.keys.remove(this.indexFor(o));
            return true;
        }
        return false;
    }

    @Override
    public Iterator<E> iterator() {
        return this.delegate.iterator();
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    private int indexFor(Object o) {
        Integer result = MapUtils.getKey(this.keys, o);
        return result != null ? result : -1;
    }

    @Override
    public Collection<E> getDelegate() {
        return this.delegate;
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }
}

