/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.collection;

import com.github.paganini2008.devtools.RandomUtils;
import com.github.paganini2008.devtools.collection.BoundedCollection;
import com.github.paganini2008.devtools.collection.LruMapSupplier;
import com.github.paganini2008.devtools.collection.MapUtils;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicInteger;

public class LruSet<E>
extends AbstractSet<E>
implements Set<E>,
Serializable,
BoundedCollection<E> {
    private static final long serialVersionUID = 1472051002956521109L;
    private final Set<E> delegate;
    private final Map<E, Object> keys;
    private static final Map<Integer, AtomicInteger> counter = new ConcurrentHashMap<Integer, AtomicInteger>();

    public LruSet() {
        this(128);
    }

    public LruSet(int maxSize) {
        this(new CopyOnWriteArraySet(), maxSize);
    }

    public LruSet(int maxSize, LruMapSupplier<E, Object> supplier) {
        this(new CopyOnWriteArraySet(), maxSize, supplier);
    }

    public LruSet(Set<E> delegate, int maxSize) {
        this(delegate, maxSize, (size, listener) -> MapUtils.synchronizedLinkedHashMap(16, size, listener));
    }

    public LruSet(Set<E> delegate, int maxSize, LruMapSupplier<E, Object> supplier) {
        this.delegate = delegate;
        this.keys = supplier.get(maxSize, (key, value) -> {
            delegate.remove(key);
            this.onEviction(key);
        });
    }

    @Override
    public boolean contains(Object o) {
        if (this.delegate.contains(o)) {
            this.keys.get(o);
            return true;
        }
        return false;
    }

    @Override
    public boolean add(E e) {
        if (this.delegate.add(e)) {
            this.keys.put(e, e);
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(Object o) {
        if (this.delegate.remove(o)) {
            this.keys.remove(o);
            return true;
        }
        return false;
    }

    @Override
    public Iterator<E> iterator() {
        return this.delegate.iterator();
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public void clear() {
        this.delegate.clear();
        this.keys.clear();
    }

    @Override
    public Collection<E> getDelegate() {
        return this.delegate;
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    public static void main(String[] args) {
        LruSet<Integer> list = new LruSet<Integer>(20);
        for (int i = 0; i < 10000; ++i) {
            int value = RandomUtils.randomInt(1, 20);
            list.add(value);
            MapUtils.get(counter, Integer.valueOf(value), () -> new AtomicInteger(0)).incrementAndGet();
        }
        System.out.println(list);
        System.out.println("-------------------------------------");
        System.out.println(counter);
    }
}

