/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.collection;

import com.github.paganini2008.devtools.collection.MapUtils;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.function.Supplier;

public class MultiMappedMap<K, N, V>
extends AbstractMap<K, Map<N, V>>
implements Map<K, Map<N, V>>,
Serializable {
    private static final long serialVersionUID = 1256299819433654455L;
    private final Map<K, Map<N, V>> delegate;
    private final Supplier<Map<N, V>> supplier;

    public MultiMappedMap() {
        this(new ConcurrentHashMap(), () -> new ConcurrentHashMap());
    }

    public MultiMappedMap(Comparator<N> c) {
        this(new ConcurrentHashMap(), () -> new ConcurrentSkipListMap(c));
    }

    public MultiMappedMap(Supplier<Map<N, V>> supplier) {
        this(new ConcurrentHashMap(), supplier);
    }

    public MultiMappedMap(Map<K, Map<N, V>> delegate) {
        this(delegate, () -> new ConcurrentHashMap());
    }

    public MultiMappedMap(Map<K, Map<N, V>> delegate, Supplier<Map<N, V>> supplier) {
        this.delegate = delegate;
        this.supplier = supplier;
    }

    public V get(K key, N name) {
        return this.get(key, name, (V)null);
    }

    public V get(K key, N name, V defaultValue) {
        return (V)this.get(key, name, () -> defaultValue);
    }

    public V get(K key, N name, Supplier<V> valueSupplier) {
        Map map = this.delegate.getOrDefault(key, MapUtils.emptyMap());
        return map.getOrDefault(name, valueSupplier.get());
    }

    public V getIfNecessary(K key, N name, V defaultValue) {
        return (V)this.getIfNecessary(key, name, () -> defaultValue);
    }

    public V getIfNecessary(K key, N name, Supplier<V> valueSupplier) {
        V v;
        Map<N, V> map = this.delegate.get(key);
        if (map == null) {
            this.delegate.putIfAbsent(key, this.supplier.get());
            map = this.delegate.get(key);
        }
        if ((v = map.get(name)) == null) {
            map.put(name, valueSupplier.get());
            v = map.get(name);
        }
        return v;
    }

    @Override
    public Map<N, V> get(Object key) {
        return this.delegate.get(key);
    }

    @Override
    public Map<N, V> remove(Object key) {
        return this.delegate.remove(key);
    }

    public V removeValue(K key, N name) {
        Map<N, V> map = this.delegate.get(key);
        if (map != null) {
            return map.remove(name);
        }
        return null;
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    public void clear(K key) {
        Map<N, V> map = this.delegate.get(key);
        if (map != null) {
            map.clear();
        }
    }

    @Override
    public boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    public boolean containsValue(K key, N name) {
        Map<N, V> map = this.delegate.get(key);
        if (map != null) {
            return map.containsKey(name);
        }
        return false;
    }

    public void append(K key, Map<N, V> value) {
        Map<N, V> map = this.delegate.get(key);
        if (map == null) {
            this.delegate.putIfAbsent(key, this.supplier.get());
            map = this.delegate.get(key);
        }
        map.putAll(value);
    }

    @Override
    public Map<N, V> put(K key, Map<N, V> value) {
        return this.delegate.put(key, value);
    }

    public V put(K key, N name, V value) {
        Map<N, V> map = this.delegate.get(key);
        if (map == null) {
            this.delegate.putIfAbsent(key, this.supplier.get());
            map = this.delegate.get(key);
        }
        return map.put(name, value);
    }

    public V putIfAbsent(K key, N name, V value) {
        return (V)this.putIfAbsent(key, name, () -> value);
    }

    public V putIfAbsent(K key, N name, Supplier<V> valueSupplier) {
        Map<N, V> map = this.delegate.get(key);
        if (map == null) {
            this.delegate.putIfAbsent(key, this.supplier.get());
            map = this.delegate.get(key);
        }
        return map.putIfAbsent(name, valueSupplier.get());
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    public int size(K key) {
        Map<N, V> map = this.delegate.get(key);
        return map != null ? map.size() : 0;
    }

    @Override
    public Set<K> keySet() {
        return this.delegate.keySet();
    }

    @Override
    public Set<Map.Entry<K, Map<N, V>>> entrySet() {
        return this.delegate.entrySet();
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }
}

