/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.collection;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.function.Supplier;

public class MultiSetMap<K, V>
extends AbstractMap<K, NavigableSet<V>>
implements Map<K, NavigableSet<V>>,
Serializable {
    private static final long serialVersionUID = 83462015304015642L;
    private final Map<K, NavigableSet<V>> delegate;
    private final Supplier<NavigableSet<V>> supplier;

    public MultiSetMap() {
        this(new ConcurrentHashMap(), () -> new ConcurrentSkipListSet());
    }

    public MultiSetMap(Comparator<V> c) {
        this(new ConcurrentHashMap(), () -> new ConcurrentSkipListSet(c));
    }

    public MultiSetMap(Supplier<NavigableSet<V>> supplier) {
        this(new ConcurrentHashMap(), supplier);
    }

    public MultiSetMap(Map<K, NavigableSet<V>> delegate, Supplier<NavigableSet<V>> supplier) {
        this.delegate = delegate;
        this.supplier = supplier;
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    public void clear(K key) {
        Set set = this.delegate.get(key);
        if (set != null) {
            set.clear();
        }
    }

    @Override
    public NavigableSet<V> remove(Object key) {
        return this.delegate.remove(key);
    }

    public V pollLast(K key) {
        NavigableSet<V> set = this.delegate.get(key);
        return set != null ? (V)set.pollLast() : null;
    }

    public V pollFirst(K key) {
        NavigableSet<V> set = this.delegate.get(key);
        return set != null ? (V)set.pollFirst() : null;
    }

    public V peekFirst(K key) {
        NavigableSet<V> set = this.delegate.get(key);
        return set != null ? (V)set.first() : null;
    }

    public V peekLast(K key) {
        NavigableSet<V> set = this.delegate.get(key);
        return set != null ? (V)set.last() : null;
    }

    @Override
    public NavigableSet<V> get(Object key) {
        return this.delegate.get(key);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    public void removeValue(K key, V value) {
        NavigableSet<V> set = this.delegate.get(key);
        if (set != null) {
            while (set.contains(value)) {
                set.remove(value);
            }
        }
    }

    @Override
    public Set<Map.Entry<K, NavigableSet<V>>> entrySet() {
        return this.delegate.entrySet();
    }

    public boolean containsValue(K key, V value) {
        NavigableSet<V> q = this.delegate.get(key);
        return q != null ? q.contains(value) : false;
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    public int size(K key) {
        NavigableSet<V> q = this.delegate.get(key);
        return q != null ? q.size() : 0;
    }

    @Override
    public Set<K> keySet() {
        return this.delegate.keySet();
    }

    @Override
    public NavigableSet<V> put(K key, NavigableSet<V> value) {
        return this.delegate.put(key, value);
    }

    public void addAll(K key, Collection<V> values) {
        NavigableSet<V> set = this.delegate.get(key);
        if (set == null) {
            this.delegate.putIfAbsent(key, this.supplier.get());
            set = this.delegate.get(key);
        }
        set.addAll(values);
    }

    public V add(K key, V value) {
        NavigableSet<V> set = this.delegate.get(key);
        if (set == null) {
            this.delegate.putIfAbsent(key, this.supplier.get());
            set = this.delegate.get(key);
        }
        set.add(value);
        return value;
    }

    public Map<K, V> toSingleValueMap() {
        HashMap map = new HashMap();
        for (Map.Entry<K, NavigableSet<V>> entry : this.delegate.entrySet()) {
            map.put(entry.getKey(), entry.getValue().first());
        }
        return map;
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }
}

