/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.collection;

import com.github.paganini2008.devtools.MatchMode;
import com.github.paganini2008.devtools.collection.MapUtils;
import com.github.paganini2008.devtools.collection.ReadonlyProperties;
import com.github.paganini2008.devtools.io.FileUtils;
import com.github.paganini2008.devtools.io.IOUtils;
import com.github.paganini2008.devtools.multithreads.Executable;
import com.github.paganini2008.devtools.multithreads.ThreadUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Timer;
import java.util.concurrent.TimeUnit;

public abstract class RefreshingProperties
extends ReadonlyProperties
implements Executable {
    private static final long serialVersionUID = 1L;
    protected Properties delegate;
    private Timer timer;

    protected abstract Properties createObject() throws Exception;

    public synchronized boolean refresh() throws Exception {
        boolean hasChanged = false;
        Properties lastest = this.createObject();
        Properties current = null;
        if (this.delegate != null) {
            current = (Properties)this.delegate.clone();
            hasChanged = !MapUtils.deepEquals(lastest, current);
        }
        this.delegate = lastest;
        if (hasChanged) {
            this.onChange(lastest, current);
        }
        return hasChanged;
    }

    protected void onChange(Properties lastest, Properties current) {
    }

    @Override
    public boolean containsValue(Object value) {
        return this.delegate.containsValue(value);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public Object get(Object key) {
        return this.delegate.get(key);
    }

    @Override
    public Collection<Object> values() {
        return this.delegate.values();
    }

    @Override
    public Set<Object> keySet() {
        return this.delegate.keySet();
    }

    @Override
    public Set<Map.Entry<Object, Object>> entrySet() {
        return this.delegate.entrySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(File outputFile, String comments) throws IOException {
        FileOutputStream out = null;
        try {
            out = FileUtils.openOutputStream(outputFile, false);
            this.delegate.store(out, comments);
        }
        finally {
            IOUtils.closeQuietly(out);
        }
    }

    @Override
    public void store(Writer writer, String comments) throws IOException {
        this.delegate.store(writer, comments);
    }

    @Override
    public void store(OutputStream out, String comments) throws IOException {
        this.delegate.store(out, comments);
    }

    @Override
    public void storeToXML(OutputStream os, String comment) throws IOException {
        this.delegate.storeToXML(os, comment);
    }

    @Override
    public void storeToXML(OutputStream os, String comment, String encoding) throws IOException {
        this.delegate.storeToXML(os, comment, encoding);
    }

    @Override
    public String getProperty(String key) {
        return this.delegate.getProperty(key);
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        return this.delegate.getProperty(key, defaultValue);
    }

    @Override
    public Enumeration<?> propertyNames() {
        return this.delegate.propertyNames();
    }

    @Override
    public Set<String> stringPropertyNames() {
        return this.delegate.stringPropertyNames();
    }

    @Override
    public void list(PrintStream out) {
        this.delegate.list(out);
    }

    @Override
    public void list(PrintWriter out) {
        this.delegate.list(out);
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    public Map<String, String> toMap() {
        return MapUtils.toMap(this.delegate);
    }

    public Map<String, String> toMap(String substr, MatchMode mode) {
        Map<String, String> m = this.toMap();
        return MapUtils.toMatchedKeyMap(m, substr, mode);
    }

    @Override
    public boolean execute() {
        try {
            this.refresh();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void setInterval(long interval, TimeUnit timeUnit) throws Exception {
        if (this.timer == null) {
            this.refresh();
            this.timer = ThreadUtils.scheduleAtFixedRate((Executable)this, interval, timeUnit);
        }
    }

    public void clearInterval() {
        if (this.timer != null) {
            this.timer.cancel();
        }
    }
}

