/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.collection;

import com.github.paganini2008.devtools.ArrayUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public abstract class SetUtils {
    public static <T> Set<T> emptySet() {
        return Collections.EMPTY_SET;
    }

    public static <T> Set<T> unmodifiableSet(T ... args) {
        return Collections.unmodifiableSet(SetUtils.create(args));
    }

    public static <T> Set<T> unmodifiableSet(Collection<T> c) {
        return Collections.unmodifiableSet(SetUtils.toSet(c));
    }

    public static <T> Set<T> synchronizedSet() {
        return Collections.synchronizedSet(new HashSet());
    }

    public static <T> Set<T> synchronizedSet(Collection<T> c) {
        return Collections.synchronizedSet(SetUtils.toSet(c));
    }

    public static <T> Set<T> create(T ... args) {
        return ArrayUtils.isNotEmpty(args) ? new HashSet<T>(Arrays.asList(args)) : new HashSet();
    }

    public static <T> Set<T> toSet(Collection<T> c) {
        return c instanceof Set ? (Set<Object>)c : new HashSet<T>(c);
    }

    public static boolean isSet(Object obj) {
        return obj == null ? false : obj instanceof Set;
    }

    public static boolean isNotSet(Object obj) {
        return !SetUtils.isSet(obj);
    }
}

