/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.collection;

import com.github.paganini2008.devtools.collection.ReferenceMap;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SoftReferenceMap<K, V>
extends ReferenceMap<K, V>
implements Map<K, V> {
    private final ReferenceQueue<V> rq = new ReferenceQueue();

    public SoftReferenceMap() {
        super(new ConcurrentHashMap());
    }

    @Override
    public V put(K key, V value) {
        V prev = super.put(key, value);
        this.enableCapacity();
        return prev;
    }

    private void enableCapacity() {
        Ref ref;
        while ((ref = (Ref)this.rq.poll()) != null) {
            this.remove(ref.key);
            this.onEviction(ref.key, null);
        }
    }

    protected void onEviction(K key, V value) {
    }

    @Override
    protected Reference<V> fold(K key, V value) {
        return new Ref(key, value, this.rq);
    }

    class Ref
    extends SoftReference<V> {
        final K key;

        Ref(K key, V value, ReferenceQueue<V> rq) {
            super(value, rq);
            this.key = key;
        }
    }
}

