/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.comparator;

import com.github.paganini2008.devtools.collection.MapUtils;
import com.github.paganini2008.devtools.comparator.ComparatorHelper;
import com.github.paganini2008.devtools.comparator.ReverseComparator;
import java.util.Comparator;
import java.util.Map;

public abstract class MapComparator<K, V>
implements Comparator<Map.Entry<K, V>> {
    public Map<K, V> sort(Map<K, V> map) {
        return MapUtils.sort(map, this);
    }

    public ReverseComparator<Map.Entry<K, V>> reverse() {
        return new ReverseComparator<Map.Entry<K, V>>(this);
    }

    public static <K extends Comparable<K>, V> MapComparator<K, V> byKey() {
        return new ByKeyMapComparator();
    }

    public static <K, V extends Comparable<V>> MapComparator<K, V> byValue() {
        return new ByValueMapComparator();
    }

    public static void main(String[] args) {
    }

    static class ByValueMapComparator<K, V extends Comparable<V>>
    extends MapComparator<K, V> {
        ByValueMapComparator() {
        }

        @Override
        public int compare(Map.Entry<K, V> a, Map.Entry<K, V> b) {
            return ComparatorHelper.compareTo((Comparable)a.getValue(), (Comparable)b.getValue());
        }
    }

    static class ByKeyMapComparator<K extends Comparable<K>, V>
    extends MapComparator<K, V> {
        ByKeyMapComparator() {
        }

        @Override
        public int compare(Map.Entry<K, V> a, Map.Entry<K, V> b) {
            return ComparatorHelper.compareTo((Comparable)a.getKey(), (Comparable)b.getKey());
        }
    }
}

