/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.converter;

import com.github.paganini2008.devtools.converter.Converter;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class BasicConverter<T>
implements Converter<Object, T> {
    private final Map<Class<?>, Converter<?, T>> converterRegistry = new ConcurrentHashMap();

    public void registerType(Class<?> javaType, Converter<?, T> converter) {
        this.converterRegistry.put(javaType, converter);
    }

    public void removeType(Class<?> javaType) {
        this.converterRegistry.remove(javaType);
    }

    public Converter<?, T> lookupType(Class<?> javaType) {
        return this.converterRegistry.get(javaType);
    }

    public boolean hasType(Class<?> javaType) {
        return this.converterRegistry.containsKey(javaType);
    }

    @Override
    public T convertValue(Object value, T defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        Class<?> matches = this.getAssignableClass(value.getClass());
        if (matches != null) {
            Converter<?, T> converter = this.lookupType(matches);
            return converter.convertValue(value, defaultValue);
        }
        return defaultValue;
    }

    protected Class<?> getAssignableClass(Class<?> actual) {
        for (Class<?> type : this.converterRegistry.keySet()) {
            if (!type.equals(actual) && !type.isAssignableFrom(actual)) continue;
            return type;
        }
        return null;
    }
}

