/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.converter;

import com.github.paganini2008.devtools.converter.BasicConverter;
import com.github.paganini2008.devtools.converter.Converter;
import com.github.paganini2008.devtools.math.BigIntegerUtils;
import java.math.BigInteger;

public class BigIntegerConverter
extends BasicConverter<BigInteger> {
    private final Converter<Number, BigInteger> numberConverter = new Converter<Number, BigInteger>(){

        @Override
        public BigInteger convertValue(Number source, BigInteger defaultValue) {
            return BigIntegerUtils.valueOf(source, defaultValue);
        }
    };
    private final Converter<Boolean, BigInteger> booleanConverter = new Converter<Boolean, BigInteger>(){

        @Override
        public BigInteger convertValue(Boolean source, BigInteger defaultValue) {
            return BigIntegerUtils.valueOf(source, defaultValue);
        }
    };
    private final Converter<Character, BigInteger> characterConverter = new Converter<Character, BigInteger>(){

        @Override
        public BigInteger convertValue(Character source, BigInteger defaultValue) {
            return BigIntegerUtils.valueOf(source, defaultValue);
        }
    };
    private final Converter<String, BigInteger> stringConverter = new Converter<String, BigInteger>(){

        @Override
        public BigInteger convertValue(String source, BigInteger defaultValue) {
            return BigIntegerUtils.valueOf(source, defaultValue);
        }
    };

    public BigIntegerConverter() {
        this.registerType(Number.class, this.numberConverter);
        this.registerType(String.class, this.stringConverter);
        this.registerType(Boolean.class, this.booleanConverter);
        this.registerType(Character.class, this.characterConverter);
    }
}

