/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.converter;

import com.github.paganini2008.devtools.converter.BasicConverter;
import com.github.paganini2008.devtools.converter.Converter;
import com.github.paganini2008.devtools.primitives.Chars;

public class CharacterObjectArrayConverter
extends BasicConverter<Character[]> {
    private final Converter<char[], Character[]> charArrayConverter = new Converter<char[], Character[]>(){

        @Override
        public Character[] convertValue(char[] source, Character[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return Chars.toWrappers(source);
        }
    };
    private final Converter<CharSequence, Character[]> stringConverter = new Converter<CharSequence, Character[]>(){

        @Override
        public Character[] convertValue(CharSequence source, Character[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return Chars.toCharacterArray(source);
        }
    };

    public CharacterObjectArrayConverter() {
        this.registerType(char[].class, this.charArrayConverter);
        this.registerType(CharSequence.class, this.stringConverter);
    }
}

