/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.converter;

import com.github.paganini2008.devtools.StringUtils;
import com.github.paganini2008.devtools.converter.BasicConverter;
import com.github.paganini2008.devtools.converter.Converter;
import com.github.paganini2008.devtools.primitives.Doubles;
import java.util.List;

public class DoubleArrayConverter
extends BasicConverter<double[]> {
    private final Converter<CharSequence, double[]> charSequenceConverter = new Converter<CharSequence, double[]>(){

        @Override
        public double[] convertValue(CharSequence source, double[] defaultValue) {
            if (StringUtils.isBlank(source)) {
                return defaultValue;
            }
            List<String> result = StringUtils.split(source, DoubleArrayConverter.this.delimiter);
            return result != null ? Doubles.parseMany(result.toArray(new String[result.size()])) : defaultValue;
        }
    };
    private final Converter<String[], double[]> stringArrayConverter = new Converter<String[], double[]>(){

        @Override
        public double[] convertValue(String[] source, double[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return Doubles.parseMany(source);
        }
    };
    private final Converter<Number[], double[]> numberArrayConverter = new Converter<Number[], double[]>(){

        @Override
        public double[] convertValue(Number[] source, double[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return Doubles.casts(source);
        }
    };
    private final Converter<char[], double[]> charArrayConverter = new Converter<char[], double[]>(){

        @Override
        public double[] convertValue(char[] source, double[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return Doubles.casts(source);
        }
    };
    private final Converter<boolean[], double[]> booleanArrayConverter = new Converter<boolean[], double[]>(){

        @Override
        public double[] convertValue(boolean[] source, double[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return Doubles.casts(source);
        }
    };
    private final Converter<byte[], double[]> byteArrayConverter = new Converter<byte[], double[]>(){

        @Override
        public double[] convertValue(byte[] source, double[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return Doubles.casts(source);
        }
    };
    private final Converter<int[], double[]> intArrayConverter = new Converter<int[], double[]>(){

        @Override
        public double[] convertValue(int[] source, double[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return Doubles.casts(source);
        }
    };
    private final Converter<long[], double[]> longArrayConverter = new Converter<long[], double[]>(){

        @Override
        public double[] convertValue(long[] source, double[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return Doubles.casts(source);
        }
    };
    private final Converter<float[], double[]> floatArrayConverter = new Converter<float[], double[]>(){

        @Override
        public double[] convertValue(float[] source, double[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return Doubles.casts(source);
        }
    };
    private String delimiter = ",";

    public DoubleArrayConverter() {
        this.registerType(CharSequence.class, this.charSequenceConverter);
        this.registerType(Number[].class, this.numberArrayConverter);
        this.registerType(String[].class, this.stringArrayConverter);
        this.registerType(char[].class, this.charArrayConverter);
        this.registerType(boolean[].class, this.booleanArrayConverter);
        this.registerType(byte[].class, this.byteArrayConverter);
        this.registerType(int[].class, this.intArrayConverter);
        this.registerType(long[].class, this.longArrayConverter);
        this.registerType(float[].class, this.floatArrayConverter);
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }
}

