/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.converter;

import com.github.paganini2008.devtools.StringUtils;
import com.github.paganini2008.devtools.converter.BasicConverter;
import com.github.paganini2008.devtools.converter.Converter;
import com.github.paganini2008.devtools.primitives.Floats;
import java.util.List;

public class FloatArrayConverter
extends BasicConverter<float[]> {
    private final Converter<CharSequence, float[]> charSequenceConverter = new Converter<CharSequence, float[]>(){

        @Override
        public float[] convertValue(CharSequence source, float[] defaultValue) {
            if (StringUtils.isBlank(source)) {
                return defaultValue;
            }
            List<String> result = StringUtils.split(source, FloatArrayConverter.this.delimiter);
            return result != null ? Floats.parseMany(result.toArray(new String[result.size()])) : defaultValue;
        }
    };
    private final Converter<String[], float[]> stringArrayConverter = new Converter<String[], float[]>(){

        @Override
        public float[] convertValue(String[] source, float[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return Floats.parseMany(source);
        }
    };
    private final Converter<Number[], float[]> numberArrayConverter = new Converter<Number[], float[]>(){

        @Override
        public float[] convertValue(Number[] source, float[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return Floats.casts(source);
        }
    };
    private final Converter<char[], float[]> charArrayConverter = new Converter<char[], float[]>(){

        @Override
        public float[] convertValue(char[] source, float[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return Floats.casts(source);
        }
    };
    private final Converter<boolean[], float[]> booleanArrayConverter = new Converter<boolean[], float[]>(){

        @Override
        public float[] convertValue(boolean[] source, float[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return Floats.casts(source);
        }
    };
    private final Converter<byte[], float[]> byteArrayConverter = new Converter<byte[], float[]>(){

        @Override
        public float[] convertValue(byte[] source, float[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return Floats.casts(source);
        }
    };
    private final Converter<int[], float[]> intArrayConverter = new Converter<int[], float[]>(){

        @Override
        public float[] convertValue(int[] source, float[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return Floats.casts(source);
        }
    };
    private final Converter<long[], float[]> longArrayConverter = new Converter<long[], float[]>(){

        @Override
        public float[] convertValue(long[] source, float[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return Floats.casts(source);
        }
    };
    private final Converter<double[], float[]> doubleArrayConverter = new Converter<double[], float[]>(){

        @Override
        public float[] convertValue(double[] source, float[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return Floats.casts(source);
        }
    };
    private String delimiter = ",";

    public FloatArrayConverter() {
        this.registerType(CharSequence.class, this.charSequenceConverter);
        this.registerType(Number[].class, this.numberArrayConverter);
        this.registerType(String[].class, this.stringArrayConverter);
        this.registerType(char[].class, this.charArrayConverter);
        this.registerType(boolean[].class, this.booleanArrayConverter);
        this.registerType(byte[].class, this.byteArrayConverter);
        this.registerType(int[].class, this.intArrayConverter);
        this.registerType(long[].class, this.longArrayConverter);
        this.registerType(double[].class, this.doubleArrayConverter);
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }
}

