/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.converter;

import com.github.paganini2008.devtools.StringUtils;
import com.github.paganini2008.devtools.converter.BasicConverter;
import com.github.paganini2008.devtools.converter.Converter;
import com.github.paganini2008.devtools.primitives.Floats;
import java.util.List;

public class FloatObjectArrayConverter
extends BasicConverter<Float[]> {
    private final Converter<CharSequence, Float[]> charSequenceConverter = new Converter<CharSequence, Float[]>(){

        @Override
        public Float[] convertValue(CharSequence source, Float[] defaultValue) {
            if (StringUtils.isBlank(source)) {
                return defaultValue;
            }
            List<String> result = StringUtils.split(source, ",");
            return result != null ? Floats.valueOf(result.toArray(new String[result.size()])) : defaultValue;
        }
    };
    private final Converter<Number[], Float[]> numberConverter = new Converter<Number[], Float[]>(){

        @Override
        public Float[] convertValue(Number[] source, Float[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return Floats.valueOf(source);
        }
    };
    private final Converter<String[], Float[]> stringConverter = new Converter<String[], Float[]>(){

        @Override
        public Float[] convertValue(String[] source, Float[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return Floats.valueOf(source);
        }
    };
    private final Converter<byte[], Float[]> byteArrayConverter = new Converter<byte[], Float[]>(){

        @Override
        public Float[] convertValue(byte[] source, Float[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return Floats.toWrappers(source);
        }
    };
    private final Converter<short[], Float[]> shortArrayConverter = new Converter<short[], Float[]>(){

        @Override
        public Float[] convertValue(short[] source, Float[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return Floats.toWrappers(source);
        }
    };
    private final Converter<char[], Float[]> charArrayConverter = new Converter<char[], Float[]>(){

        @Override
        public Float[] convertValue(char[] source, Float[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return Floats.toWrappers(source);
        }
    };
    private final Converter<int[], Float[]> intArrayConverter = new Converter<int[], Float[]>(){

        @Override
        public Float[] convertValue(int[] source, Float[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return Floats.toWrappers(source);
        }
    };
    private final Converter<float[], Float[]> floatArrayConverter = new Converter<float[], Float[]>(){

        @Override
        public Float[] convertValue(float[] source, Float[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return Floats.toWrappers(source);
        }
    };
    private final Converter<long[], Float[]> longArrayConverter = new Converter<long[], Float[]>(){

        @Override
        public Float[] convertValue(long[] source, Float[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return Floats.toWrappers(source);
        }
    };

    public FloatObjectArrayConverter() {
        this.registerType(CharSequence.class, this.charSequenceConverter);
        this.registerType(Number[].class, this.numberConverter);
        this.registerType(String[].class, this.stringConverter);
        this.registerType(byte[].class, this.byteArrayConverter);
        this.registerType(char[].class, this.charArrayConverter);
        this.registerType(short[].class, this.shortArrayConverter);
        this.registerType(int[].class, this.intArrayConverter);
        this.registerType(long[].class, this.longArrayConverter);
        this.registerType(float[].class, this.floatArrayConverter);
    }
}

