/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.converter;

import com.github.paganini2008.devtools.StringUtils;
import com.github.paganini2008.devtools.converter.BasicConverter;
import com.github.paganini2008.devtools.converter.Converter;
import com.github.paganini2008.devtools.primitives.Ints;
import java.util.List;

public class IntegerObjectArrayConverter
extends BasicConverter<Integer[]> {
    private final Converter<CharSequence, Integer[]> charSequenceConverter = new Converter<CharSequence, Integer[]>(){

        @Override
        public Integer[] convertValue(CharSequence source, Integer[] defaultValue) {
            if (StringUtils.isBlank(source)) {
                return defaultValue;
            }
            List<String> result = StringUtils.split(source, IntegerObjectArrayConverter.this.delimiter);
            return result != null ? Ints.valueOf(result.toArray(new String[result.size()])) : defaultValue;
        }
    };
    private final Converter<Number[], Integer[]> numberArrayConverter = new Converter<Number[], Integer[]>(){

        @Override
        public Integer[] convertValue(Number[] source, Integer[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return Ints.valueOf(source);
        }
    };
    private final Converter<String[], Integer[]> stringArrayConverter = new Converter<String[], Integer[]>(){

        @Override
        public Integer[] convertValue(String[] source, Integer[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return Ints.valueOf(source);
        }
    };
    private final Converter<byte[], Integer[]> byteArrayConverter = new Converter<byte[], Integer[]>(){

        @Override
        public Integer[] convertValue(byte[] source, Integer[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return Ints.toWrappers(source);
        }
    };
    private final Converter<short[], Integer[]> shortArrayConverter = new Converter<short[], Integer[]>(){

        @Override
        public Integer[] convertValue(short[] source, Integer[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return Ints.toWrappers(source);
        }
    };
    private final Converter<char[], Integer[]> charArrayConverter = new Converter<char[], Integer[]>(){

        @Override
        public Integer[] convertValue(char[] source, Integer[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return Ints.toWrappers(source);
        }
    };
    private final Converter<int[], Integer[]> intArrayConverter = new Converter<int[], Integer[]>(){

        @Override
        public Integer[] convertValue(int[] source, Integer[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return Ints.toWrappers(source);
        }
    };
    private String delimiter = ",";

    public IntegerObjectArrayConverter() {
        this.registerType(CharSequence.class, this.charSequenceConverter);
        this.registerType(Number[].class, this.numberArrayConverter);
        this.registerType(String[].class, this.stringArrayConverter);
        this.registerType(byte[].class, this.byteArrayConverter);
        this.registerType(char[].class, this.shortArrayConverter);
        this.registerType(short[].class, this.charArrayConverter);
        this.registerType(int[].class, this.intArrayConverter);
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }
}

