/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.converter;

import com.github.paganini2008.devtools.converter.BasicConverter;
import com.github.paganini2008.devtools.converter.Converter;
import com.github.paganini2008.devtools.time.LocalDateTimeUtils;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;

public class LocalDateTimeConverter
extends BasicConverter<LocalDateTime> {
    private final Converter<Long, LocalDateTime> longConverter = new Converter<Long, LocalDateTime>(){

        @Override
        public LocalDateTime convertValue(Long source, LocalDateTime defaultValue) {
            return LocalDateTimeUtils.toLocalDateTime(source, LocalDateTimeConverter.this.zoneId, defaultValue);
        }
    };
    private final Converter<Instant, LocalDateTime> instantConverter = new Converter<Instant, LocalDateTime>(){

        @Override
        public LocalDateTime convertValue(Instant source, LocalDateTime defaultValue) {
            return LocalDateTimeUtils.toLocalDateTime(source, LocalDateTimeConverter.this.zoneId, defaultValue);
        }
    };
    private final Converter<String, LocalDateTime> stringConverter = new Converter<String, LocalDateTime>(){

        @Override
        public LocalDateTime convertValue(String source, LocalDateTime defaultValue) {
            return LocalDateTimeUtils.parseLocalDateTime(source, LocalDateTimeConverter.this.dateTimeFormatter, defaultValue);
        }
    };
    private final Converter<Date, LocalDateTime> dateConverter = new Converter<Date, LocalDateTime>(){

        @Override
        public LocalDateTime convertValue(Date source, LocalDateTime defaultValue) {
            return LocalDateTimeUtils.toLocalDateTime(source, LocalDateTimeConverter.this.zoneId, defaultValue);
        }
    };
    private final Converter<Calendar, LocalDateTime> calendarConverter = new Converter<Calendar, LocalDateTime>(){

        @Override
        public LocalDateTime convertValue(Calendar source, LocalDateTime defaultValue) {
            return LocalDateTimeUtils.toLocalDateTime(source, LocalDateTimeConverter.this.zoneId, defaultValue);
        }
    };
    private final Converter<LocalDate, LocalDateTime> localDateConverter = new Converter<LocalDate, LocalDateTime>(){

        @Override
        public LocalDateTime convertValue(LocalDate source, LocalDateTime defaultValue) {
            return LocalDateTimeUtils.toLocalDateTime(source, defaultValue);
        }
    };
    private ZoneId zoneId = ZoneId.systemDefault();
    private DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ISO_LOCAL_DATE_TIME;

    public LocalDateTimeConverter() {
        this.registerType(Long.class, this.longConverter);
        this.registerType(Instant.class, this.instantConverter);
        this.registerType(String.class, this.stringConverter);
        this.registerType(Date.class, this.dateConverter);
        this.registerType(Calendar.class, this.calendarConverter);
        this.registerType(LocalDate.class, this.localDateConverter);
    }

    public void setZoneId(ZoneId zoneId) {
        this.zoneId = zoneId;
    }

    public void setDateTimeFormatter(DateTimeFormatter dateTimeFormatter) {
        this.dateTimeFormatter = dateTimeFormatter;
    }
}

