/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.converter;

import com.github.paganini2008.devtools.converter.BasicConverter;
import com.github.paganini2008.devtools.converter.Converter;
import com.github.paganini2008.devtools.time.LocalTimeUtils;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;

public class LocalTimeConverter
extends BasicConverter<LocalTime> {
    private final Converter<Long, LocalTime> longConverter = new Converter<Long, LocalTime>(){

        @Override
        public LocalTime convertValue(Long source, LocalTime defaultValue) {
            return LocalTimeUtils.toLocalTime(source, LocalTimeConverter.this.zoneId, defaultValue);
        }
    };
    private final Converter<Instant, LocalTime> instantConverter = new Converter<Instant, LocalTime>(){

        @Override
        public LocalTime convertValue(Instant source, LocalTime defaultValue) {
            return LocalTimeUtils.toLocalTime(source, LocalTimeConverter.this.zoneId, defaultValue);
        }
    };
    private final Converter<String, LocalTime> stringConverter = new Converter<String, LocalTime>(){

        @Override
        public LocalTime convertValue(String source, LocalTime defaultValue) {
            return LocalTimeUtils.parseLocalTime(source, LocalTimeConverter.this.timeFormatter, defaultValue);
        }
    };
    private final Converter<Date, LocalTime> dateConverter = new Converter<Date, LocalTime>(){

        @Override
        public LocalTime convertValue(Date source, LocalTime defaultValue) {
            return LocalTimeUtils.toLocalTime(source, LocalTimeConverter.this.zoneId, defaultValue);
        }
    };
    private final Converter<Calendar, LocalTime> calendarConverter = new Converter<Calendar, LocalTime>(){

        @Override
        public LocalTime convertValue(Calendar source, LocalTime defaultValue) {
            return LocalTimeUtils.toLocalTime(source, LocalTimeConverter.this.zoneId, defaultValue);
        }
    };
    private final Converter<LocalDateTime, LocalTime> localDateTimeConverter = new Converter<LocalDateTime, LocalTime>(){

        @Override
        public LocalTime convertValue(LocalDateTime source, LocalTime defaultValue) {
            return LocalTimeUtils.toLocalTime(source, defaultValue);
        }
    };
    private ZoneId zoneId = ZoneId.systemDefault();
    private DateTimeFormatter timeFormatter = DateTimeFormatter.ISO_LOCAL_TIME;

    public LocalTimeConverter() {
        this.registerType(Long.class, this.longConverter);
        this.registerType(Instant.class, this.instantConverter);
        this.registerType(String.class, this.stringConverter);
        this.registerType(Date.class, this.dateConverter);
        this.registerType(Calendar.class, this.calendarConverter);
        this.registerType(LocalDateTime.class, this.localDateTimeConverter);
    }

    public void setZoneId(ZoneId zoneId) {
        this.zoneId = zoneId;
    }

    public void setTimeFormatter(DateTimeFormatter timeFormatter) {
        this.timeFormatter = timeFormatter;
    }
}

