/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.converter;

import com.github.paganini2008.devtools.StringUtils;
import com.github.paganini2008.devtools.converter.BasicConverter;
import com.github.paganini2008.devtools.converter.Converter;
import com.github.paganini2008.devtools.primitives.Longs;
import java.util.List;

public class LongArrayConverter
extends BasicConverter<long[]> {
    private final Converter<CharSequence, long[]> charSequenceConverter = new Converter<CharSequence, long[]>(){

        @Override
        public long[] convertValue(CharSequence source, long[] defaultValue) {
            if (StringUtils.isBlank(source)) {
                return defaultValue;
            }
            List<String> result = StringUtils.split(source, LongArrayConverter.this.delimiter);
            return result != null ? Longs.parseMany(result.toArray(new String[result.size()])) : defaultValue;
        }
    };
    private final Converter<String[], long[]> stringArrayConverter = new Converter<String[], long[]>(){

        @Override
        public long[] convertValue(String[] source, long[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return Longs.parseMany(source);
        }
    };
    private final Converter<Number[], long[]> numberArrayConverter = new Converter<Number[], long[]>(){

        @Override
        public long[] convertValue(Number[] source, long[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return Longs.casts(source);
        }
    };
    private final Converter<char[], long[]> charArrayConverter = new Converter<char[], long[]>(){

        @Override
        public long[] convertValue(char[] source, long[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return Longs.casts(source);
        }
    };
    private final Converter<boolean[], long[]> booleanArrayConverter = new Converter<boolean[], long[]>(){

        @Override
        public long[] convertValue(boolean[] source, long[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return Longs.casts(source);
        }
    };
    private final Converter<byte[], long[]> byteArrayConverter = new Converter<byte[], long[]>(){

        @Override
        public long[] convertValue(byte[] source, long[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return Longs.casts(source);
        }
    };
    private final Converter<short[], long[]> shortArrayConverter = new Converter<short[], long[]>(){

        @Override
        public long[] convertValue(short[] source, long[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return Longs.casts(source);
        }
    };
    private final Converter<float[], long[]> floatArrayConverter = new Converter<float[], long[]>(){

        @Override
        public long[] convertValue(float[] source, long[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return Longs.casts(source);
        }
    };
    private final Converter<double[], long[]> doubleArrayConverter = new Converter<double[], long[]>(){

        @Override
        public long[] convertValue(double[] source, long[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return Longs.casts(source);
        }
    };
    private String delimiter = ",";

    public LongArrayConverter() {
        this.registerType(CharSequence.class, this.charSequenceConverter);
        this.registerType(Number[].class, this.numberArrayConverter);
        this.registerType(String[].class, this.stringArrayConverter);
        this.registerType(char[].class, this.charArrayConverter);
        this.registerType(boolean[].class, this.booleanArrayConverter);
        this.registerType(byte[].class, this.byteArrayConverter);
        this.registerType(int[].class, this.shortArrayConverter);
        this.registerType(float[].class, this.floatArrayConverter);
        this.registerType(double[].class, this.doubleArrayConverter);
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }
}

