/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.converter;

import com.github.paganini2008.devtools.converter.BasicConverter;
import com.github.paganini2008.devtools.converter.Converter;
import com.github.paganini2008.devtools.primitives.Longs;
import com.github.paganini2008.devtools.time.CalendarUtils;
import com.github.paganini2008.devtools.time.DateUtils;
import java.time.Instant;
import java.util.Calendar;
import java.util.Date;

public class LongConverter
extends BasicConverter<Long> {
    private final Converter<Boolean, Long> booleanConverter = new Converter<Boolean, Long>(){

        @Override
        public Long convertValue(Boolean source, Long defaultValue) {
            return Longs.valueOf(source, defaultValue);
        }
    };
    private final Converter<Character, Long> characterConverter = new Converter<Character, Long>(){

        @Override
        public Long convertValue(Character source, Long defaultValue) {
            return Longs.valueOf(source, defaultValue);
        }
    };
    private final Converter<Number, Long> numberConverter = new Converter<Number, Long>(){

        @Override
        public Long convertValue(Number source, Long defaultValue) {
            return Longs.valueOf(source, defaultValue);
        }
    };
    private final Converter<String, Long> stringConverter = new Converter<String, Long>(){

        @Override
        public Long convertValue(String source, Long defaultValue) {
            return Longs.valueOf(source, defaultValue);
        }
    };
    private final Converter<Date, Long> dateConverter = new Converter<Date, Long>(){

        @Override
        public Long convertValue(Date source, Long defaultValue) {
            return DateUtils.getTimeInMillis(source, defaultValue);
        }
    };
    private final Converter<Calendar, Long> calendarConverter = new Converter<Calendar, Long>(){

        @Override
        public Long convertValue(Calendar source, Long defaultValue) {
            return CalendarUtils.getTimeInMillis(source, defaultValue);
        }
    };
    private final Converter<Instant, Long> instantConverter = new Converter<Instant, Long>(){

        @Override
        public Long convertValue(Instant source, Long defaultValue) {
            return DateUtils.getTimeInMillis(source, defaultValue);
        }
    };

    public LongConverter() {
        this.registerType(Boolean.class, this.booleanConverter);
        this.registerType(Character.class, this.characterConverter);
        this.registerType(Number.class, this.numberConverter);
        this.registerType(String.class, this.stringConverter);
        this.registerType(Date.class, this.dateConverter);
        this.registerType(Calendar.class, this.calendarConverter);
        this.registerType(Instant.class, this.instantConverter);
    }
}

