/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.converter;

import com.github.paganini2008.devtools.StringUtils;
import com.github.paganini2008.devtools.converter.BasicConverter;
import com.github.paganini2008.devtools.converter.Converter;
import com.github.paganini2008.devtools.primitives.Longs;
import com.github.paganini2008.devtools.time.CalendarUtils;
import com.github.paganini2008.devtools.time.DateUtils;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class LongObjectArrayConverter
extends BasicConverter<Long[]> {
    private final Converter<CharSequence, Long[]> charSequenceConverter = new Converter<CharSequence, Long[]>(){

        @Override
        public Long[] convertValue(CharSequence source, Long[] defaultValue) {
            if (StringUtils.isBlank(source)) {
                return defaultValue;
            }
            List<String> result = StringUtils.split(source, LongObjectArrayConverter.this.delimiter);
            return Longs.valueOf(result.toArray(new String[result.size()]));
        }
    };
    private final Converter<Character[], Long[]> characterObjectArrayConverter = new Converter<Character[], Long[]>(){

        @Override
        public Long[] convertValue(Character[] source, Long[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return Longs.valueOf(source);
        }
    };
    private final Converter<Boolean[], Long[]> booleanObjectArrayConverter = new Converter<Boolean[], Long[]>(){

        @Override
        public Long[] convertValue(Boolean[] source, Long[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return Longs.valueOf(source);
        }
    };
    private final Converter<Number[], Long[]> numberArrayConverter = new Converter<Number[], Long[]>(){

        @Override
        public Long[] convertValue(Number[] source, Long[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return Longs.valueOf(source);
        }
    };
    private final Converter<boolean[], Long[]> booleanArrayConverter = new Converter<boolean[], Long[]>(){

        @Override
        public Long[] convertValue(boolean[] source, Long[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return Longs.toWrappers(source);
        }
    };
    private final Converter<byte[], Long[]> byteArrayConverter = new Converter<byte[], Long[]>(){

        @Override
        public Long[] convertValue(byte[] source, Long[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return Longs.toWrappers(source);
        }
    };
    private final Converter<short[], Long[]> shortArrayConverter = new Converter<short[], Long[]>(){

        @Override
        public Long[] convertValue(short[] source, Long[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return Longs.toWrappers(source);
        }
    };
    private final Converter<char[], Long[]> charArrayConverter = new Converter<char[], Long[]>(){

        @Override
        public Long[] convertValue(char[] source, Long[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return Longs.toWrappers(source);
        }
    };
    private final Converter<int[], Long[]> intArrayConverter = new Converter<int[], Long[]>(){

        @Override
        public Long[] convertValue(int[] source, Long[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return Longs.toWrappers(source);
        }
    };
    private final Converter<long[], Long[]> longArrayConverter = new Converter<long[], Long[]>(){

        @Override
        public Long[] convertValue(long[] source, Long[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return Longs.toWrappers(source);
        }
    };
    private final Converter<String[], Long[]> stringArrayConverter = new Converter<String[], Long[]>(){

        @Override
        public Long[] convertValue(String[] source, Long[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return Longs.valueOf(source);
        }
    };
    private final Converter<Date[], Long[]> dateArrayConverter = new Converter<Date[], Long[]>(){

        @Override
        public Long[] convertValue(Date[] source, Long[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return DateUtils.getTimeInMillis(source);
        }
    };
    private final Converter<Calendar[], Long[]> calendarArrayConverter = new Converter<Calendar[], Long[]>(){

        @Override
        public Long[] convertValue(Calendar[] source, Long[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return CalendarUtils.getTimeInMillis(source);
        }
    };
    private String delimiter = ",";

    public LongObjectArrayConverter() {
        this.registerType(CharSequence.class, this.charSequenceConverter);
        this.registerType(Boolean[].class, this.booleanObjectArrayConverter);
        this.registerType(Character[].class, this.characterObjectArrayConverter);
        this.registerType(Number[].class, this.numberArrayConverter);
        this.registerType(String[].class, this.stringArrayConverter);
        this.registerType(Date.class, this.dateArrayConverter);
        this.registerType(Calendar.class, this.calendarArrayConverter);
        this.registerType(char[].class, this.charArrayConverter);
        this.registerType(boolean[].class, this.booleanArrayConverter);
        this.registerType(byte[].class, this.byteArrayConverter);
        this.registerType(short[].class, this.shortArrayConverter);
        this.registerType(int[].class, this.intArrayConverter);
        this.registerType(long[].class, this.longArrayConverter);
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }
}

