/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.converter;

import com.github.paganini2008.devtools.StringUtils;
import com.github.paganini2008.devtools.converter.BasicConverter;
import com.github.paganini2008.devtools.converter.Converter;
import com.github.paganini2008.devtools.primitives.Shorts;
import java.util.List;

public class ShortArrayConverter
extends BasicConverter<short[]> {
    private final Converter<CharSequence, short[]> charSequenceConverter = new Converter<CharSequence, short[]>(){

        @Override
        public short[] convertValue(CharSequence source, short[] defaultValue) {
            if (StringUtils.isBlank(source)) {
                return defaultValue;
            }
            List<String> results = StringUtils.split(source, ShortArrayConverter.this.delimiter);
            return Shorts.parseMany(results.toArray(new String[results.size()]));
        }
    };
    private final Converter<String[], short[]> stringArrayConverter = new Converter<String[], short[]>(){

        @Override
        public short[] convertValue(String[] source, short[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return Shorts.parseMany(source);
        }
    };
    private final Converter<Number[], short[]> numberArrayConverter = new Converter<Number[], short[]>(){

        @Override
        public short[] convertValue(Number[] source, short[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return Shorts.casts(source);
        }
    };
    private final Converter<char[], short[]> charArrayConverter = new Converter<char[], short[]>(){

        @Override
        public short[] convertValue(char[] source, short[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return Shorts.casts(source);
        }
    };
    private final Converter<boolean[], short[]> booleanArrayConverter = new Converter<boolean[], short[]>(){

        @Override
        public short[] convertValue(boolean[] source, short[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return Shorts.casts(source);
        }
    };
    private final Converter<byte[], short[]> byteArrayConverter = new Converter<byte[], short[]>(){

        @Override
        public short[] convertValue(byte[] source, short[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return Shorts.casts(source);
        }
    };
    private final Converter<int[], short[]> intArrayConverter = new Converter<int[], short[]>(){

        @Override
        public short[] convertValue(int[] source, short[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return Shorts.casts(source);
        }
    };
    private final Converter<long[], short[]> longArrayConverter = new Converter<long[], short[]>(){

        @Override
        public short[] convertValue(long[] source, short[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return Shorts.casts(source);
        }
    };
    private final Converter<float[], short[]> floatArrayConverter = new Converter<float[], short[]>(){

        @Override
        public short[] convertValue(float[] source, short[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return Shorts.casts(source);
        }
    };
    private final Converter<double[], short[]> doubleArrayConverter = new Converter<double[], short[]>(){

        @Override
        public short[] convertValue(double[] source, short[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return Shorts.casts(source);
        }
    };
    private String delimiter = ",";

    public ShortArrayConverter() {
        this.registerType(CharSequence.class, this.charSequenceConverter);
        this.registerType(Number[].class, this.numberArrayConverter);
        this.registerType(String[].class, this.stringArrayConverter);
        this.registerType(char[].class, this.charArrayConverter);
        this.registerType(boolean[].class, this.booleanArrayConverter);
        this.registerType(byte[].class, this.byteArrayConverter);
        this.registerType(int[].class, this.intArrayConverter);
        this.registerType(long[].class, this.longArrayConverter);
        this.registerType(float[].class, this.floatArrayConverter);
        this.registerType(double[].class, this.doubleArrayConverter);
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }
}

