/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.converter;

import com.github.paganini2008.devtools.converter.BasicConverter;
import com.github.paganini2008.devtools.converter.BigDecimaConverter;
import com.github.paganini2008.devtools.converter.BigDecimalArrayConverter;
import com.github.paganini2008.devtools.converter.BigIntegerArrayConverter;
import com.github.paganini2008.devtools.converter.BigIntegerConverter;
import com.github.paganini2008.devtools.converter.BooleanConverter;
import com.github.paganini2008.devtools.converter.ByteArrayConverter;
import com.github.paganini2008.devtools.converter.ByteConverter;
import com.github.paganini2008.devtools.converter.ByteObjectArrayConverter;
import com.github.paganini2008.devtools.converter.CalendarConverter;
import com.github.paganini2008.devtools.converter.CharArrayConverter;
import com.github.paganini2008.devtools.converter.CharacterConverter;
import com.github.paganini2008.devtools.converter.CharacterObjectArrayConverter;
import com.github.paganini2008.devtools.converter.CharsetConverter;
import com.github.paganini2008.devtools.converter.DateConverter;
import com.github.paganini2008.devtools.converter.DoubleArrayConverter;
import com.github.paganini2008.devtools.converter.DoubleConverter;
import com.github.paganini2008.devtools.converter.DoubleObjectArrayConverter;
import com.github.paganini2008.devtools.converter.FloatArrayConverter;
import com.github.paganini2008.devtools.converter.FloatConverter;
import com.github.paganini2008.devtools.converter.FloatObjectArrayConverter;
import com.github.paganini2008.devtools.converter.IntArrayConverter;
import com.github.paganini2008.devtools.converter.IntegerConverter;
import com.github.paganini2008.devtools.converter.IntegerObjectArrayConverter;
import com.github.paganini2008.devtools.converter.LocalDateConverter;
import com.github.paganini2008.devtools.converter.LocalDateTimeConverter;
import com.github.paganini2008.devtools.converter.LocalTimeConverter;
import com.github.paganini2008.devtools.converter.LocaleConverter;
import com.github.paganini2008.devtools.converter.LongArrayConverter;
import com.github.paganini2008.devtools.converter.LongConverter;
import com.github.paganini2008.devtools.converter.LongObjectArrayConverter;
import com.github.paganini2008.devtools.converter.ShortArrayConverter;
import com.github.paganini2008.devtools.converter.ShortConverter;
import com.github.paganini2008.devtools.converter.ShortObjectArrayConverter;
import com.github.paganini2008.devtools.converter.StringArrayConverter;
import com.github.paganini2008.devtools.converter.StringConverter;
import com.github.paganini2008.devtools.converter.TypeConverter;
import com.github.paganini2008.devtools.converter.UUIDConverter;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class StandardTypeConverter
implements TypeConverter {
    private static final Map<Type, BasicConverter<?>> preparedSettings = new HashMap<Type, BasicConverter<?>>(){
        private static final long serialVersionUID = 1L;
        {
            BooleanConverter booleanHandler = new BooleanConverter();
            this.put(Boolean.TYPE, booleanHandler);
            this.put(Boolean.class, booleanHandler);
            CharacterConverter characterHandler = new CharacterConverter();
            this.put(Character.TYPE, characterHandler);
            this.put(Character.class, characterHandler);
            this.put(Character[].class, new CharacterObjectArrayConverter());
            this.put(char[].class, new CharArrayConverter());
            ByteConverter byteHandler = new ByteConverter();
            this.put(Byte.TYPE, byteHandler);
            this.put(Byte.class, byteHandler);
            this.put(Byte[].class, new ByteObjectArrayConverter());
            this.put(byte[].class, new ByteArrayConverter());
            ShortConverter shortHandler = new ShortConverter();
            this.put(Short.TYPE, shortHandler);
            this.put(Short.class, shortHandler);
            this.put(Short[].class, new ShortObjectArrayConverter());
            this.put(short[].class, new ShortArrayConverter());
            IntegerConverter integerHandler = new IntegerConverter();
            this.put(Integer.TYPE, integerHandler);
            this.put(Integer.class, integerHandler);
            this.put(Integer[].class, new IntegerObjectArrayConverter());
            this.put(int[].class, new IntArrayConverter());
            FloatConverter floatHandler = new FloatConverter();
            this.put(Float.TYPE, floatHandler);
            this.put(Float.class, floatHandler);
            this.put(Float[].class, new FloatObjectArrayConverter());
            this.put(float[].class, new FloatArrayConverter());
            DoubleConverter doubleHandler = new DoubleConverter();
            this.put(Double.TYPE, doubleHandler);
            this.put(Double.class, doubleHandler);
            this.put(Double[].class, new DoubleObjectArrayConverter());
            this.put(double[].class, new DoubleArrayConverter());
            LongConverter longHandler = new LongConverter();
            this.put(Long.class, longHandler);
            this.put(Long.TYPE, longHandler);
            this.put(Long[].class, new LongObjectArrayConverter());
            this.put(long[].class, new LongArrayConverter());
            this.put(BigDecimal.class, new BigDecimaConverter());
            this.put(BigDecimal[].class, new BigDecimalArrayConverter());
            this.put(BigInteger.class, new BigIntegerConverter());
            this.put(BigInteger[].class, new BigIntegerArrayConverter());
            this.put(Date.class, new DateConverter());
            this.put(Calendar.class, new CalendarConverter());
            this.put(String.class, new StringConverter());
            this.put(String[].class, new StringArrayConverter());
            this.put(Charset.class, new CharsetConverter());
            this.put(UUID.class, new UUIDConverter());
            this.put(Locale.class, new LocaleConverter());
            this.put(LocalDate.class, new LocalDateConverter());
            this.put(LocalTime.class, new LocalTimeConverter());
            this.put(LocalDateTime.class, new LocalDateTimeConverter());
        }
    };
    private final Map<Type, BasicConverter<?>> converters = new ConcurrentHashMap(preparedSettings);

    @Override
    public <T> void registerType(Class<T> javaType, BasicConverter<T> converter) {
        this.converters.put(javaType, converter);
    }

    @Override
    public void removeType(Class<?> javaType) {
        this.converters.remove(javaType);
    }

    @Override
    public boolean hasType(Class<?> javaType) {
        return this.converters.containsKey(javaType);
    }

    @Override
    public <T> BasicConverter<T> lookupType(Class<T> javaType) {
        return this.converters.get(javaType);
    }

    @Override
    public <T> T convertValue(Object value, Class<T> requiredType, T defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        try {
            return requiredType.cast(value);
        }
        catch (ClassCastException classCastException) {
            BasicConverter<T> converter = this.lookupType(requiredType);
            if (converter != null) {
                return converter.convertValue(value, defaultValue);
            }
            return defaultValue;
        }
    }
}

