/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.converter;

import com.github.paganini2008.devtools.ArrayUtils;
import com.github.paganini2008.devtools.NumberUtils;
import com.github.paganini2008.devtools.StringUtils;
import com.github.paganini2008.devtools.collection.ListUtils;
import com.github.paganini2008.devtools.converter.BasicConverter;
import com.github.paganini2008.devtools.converter.Converter;
import com.github.paganini2008.devtools.primitives.Booleans;
import com.github.paganini2008.devtools.primitives.Bytes;
import com.github.paganini2008.devtools.primitives.Chars;
import com.github.paganini2008.devtools.primitives.Doubles;
import com.github.paganini2008.devtools.primitives.Floats;
import com.github.paganini2008.devtools.primitives.Ints;
import com.github.paganini2008.devtools.primitives.Longs;
import com.github.paganini2008.devtools.primitives.Shorts;
import com.github.paganini2008.devtools.time.CalendarUtils;
import com.github.paganini2008.devtools.time.DateUtils;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;

public class StringArrayConverter
extends BasicConverter<String[]> {
    private final Converter<CharSequence, String[]> charSequenceConverter = new Converter<CharSequence, String[]>(){

        @Override
        public String[] convertValue(CharSequence source, String[] defaultValue) {
            if (StringUtils.isBlank(source)) {
                return defaultValue;
            }
            List<String> results = StringUtils.split(source, StringArrayConverter.this.delimiter);
            return results.toArray(new String[results.size()]);
        }
    };
    private final Converter<Date[], String[]> dateArrayConverter = new Converter<Date[], String[]>(){

        @Override
        public String[] convertValue(Date[] source, String[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return DateUtils.formatMany(source, StringArrayConverter.this.dateFormat);
        }
    };
    private final Converter<Calendar[], String[]> calendarArrayConverter = new Converter<Calendar[], String[]>(){

        @Override
        public String[] convertValue(Calendar[] source, String[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return CalendarUtils.formatMany(source, StringArrayConverter.this.dateFormat);
        }
    };
    private final Converter<Number[], String[]> numberArrayConverter = new Converter<Number[], String[]>(){

        @Override
        public String[] convertValue(Number[] source, String[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return NumberUtils.toStringArray(source, StringArrayConverter.this.decimalFormat);
        }
    };
    private final Converter<Object[], String[]> objectArrayConverter = new Converter<Object[], String[]>(){

        @Override
        public String[] convertValue(Object[] source, String[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return ArrayUtils.toStringArray(source, StringArrayConverter.this.trim);
        }
    };
    private final Converter<double[], String[]> doubleArrayConverter = new Converter<double[], String[]>(){

        @Override
        public String[] convertValue(double[] source, String[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return Doubles.toStringArray(source, StringArrayConverter.this.decimalFormat);
        }
    };
    private final Converter<float[], String[]> floatArrayConverter = new Converter<float[], String[]>(){

        @Override
        public String[] convertValue(float[] source, String[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return Floats.toStringArray(source, StringArrayConverter.this.decimalFormat);
        }
    };
    private final Converter<long[], String[]> longArrayConverter = new Converter<long[], String[]>(){

        @Override
        public String[] convertValue(long[] source, String[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return Longs.toStringArray(source, StringArrayConverter.this.decimalFormat);
        }
    };
    private final Converter<int[], String[]> intArrayConverter = new Converter<int[], String[]>(){

        @Override
        public String[] convertValue(int[] source, String[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return Ints.toStringArray(source, StringArrayConverter.this.decimalFormat);
        }
    };
    private final Converter<short[], String[]> shortArrayConverter = new Converter<short[], String[]>(){

        @Override
        public String[] convertValue(short[] source, String[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return Shorts.toStringArray(source, StringArrayConverter.this.decimalFormat);
        }
    };
    private final Converter<byte[], String[]> byteArrayConverter = new Converter<byte[], String[]>(){

        @Override
        public String[] convertValue(byte[] source, String[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return Bytes.toStringArray(source, StringArrayConverter.this.decimalFormat);
        }
    };
    private final Converter<char[], String[]> charArrayConverter = new Converter<char[], String[]>(){

        @Override
        public String[] convertValue(char[] source, String[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return Chars.toStringArray(source);
        }
    };
    private final Converter<boolean[], String[]> booleanArrayConverter = new Converter<boolean[], String[]>(){

        @Override
        public String[] convertValue(boolean[] source, String[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return Booleans.toStringArray(source);
        }
    };
    private final Converter<Collection<?>, String[]> collectionConverter = new Converter<Collection<?>, String[]>(){

        @Override
        public String[] convertValue(Collection<?> source, String[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            List<String> result = ListUtils.toStringList(source);
            if (result == null) {
                return defaultValue;
            }
            return result.toArray(new String[result.size()]);
        }
    };
    private final Converter<Iterator<?>, String[]> iteratorConverter = new Converter<Iterator<?>, String[]>(){

        @Override
        public String[] convertValue(Iterator<?> source, String[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            List<String> result = ListUtils.toStringList(source);
            if (result == null) {
                return defaultValue;
            }
            return result.toArray(new String[result.size()]);
        }
    };
    private final Converter<Enumeration<?>, String[]> enumerationConverter = new Converter<Enumeration<?>, String[]>(){

        @Override
        public String[] convertValue(Enumeration<?> source, String[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            List<String> result = ListUtils.toStringList(source);
            if (result == null) {
                return defaultValue;
            }
            return result.toArray(new String[result.size()]);
        }
    };
    private DecimalFormat decimalFormat = new DecimalFormat("0.##");
    private DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private String delimiter = ",";
    private boolean trim;

    public StringArrayConverter() {
        this.registerType(CharSequence.class, this.charSequenceConverter);
        this.registerType(boolean[].class, this.booleanArrayConverter);
        this.registerType(char[].class, this.charArrayConverter);
        this.registerType(byte[].class, this.byteArrayConverter);
        this.registerType(short[].class, this.shortArrayConverter);
        this.registerType(int[].class, this.intArrayConverter);
        this.registerType(float[].class, this.floatArrayConverter);
        this.registerType(double[].class, this.doubleArrayConverter);
        this.registerType(long[].class, this.longArrayConverter);
        this.registerType(Date[].class, this.dateArrayConverter);
        this.registerType(Calendar[].class, this.calendarArrayConverter);
        this.registerType(Number[].class, this.numberArrayConverter);
        this.registerType(Object[].class, this.objectArrayConverter);
        this.registerType(Collection.class, this.collectionConverter);
        this.registerType(Iterator.class, this.iteratorConverter);
        this.registerType(Enumeration.class, this.enumerationConverter);
    }

    public void setDecimalFormat(DecimalFormat decimalFormat) {
        this.decimalFormat = decimalFormat;
    }

    public void setDateFormat(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public void setTrim(boolean trim) {
        this.trim = trim;
    }
}

