/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.enums;

import com.github.paganini2008.devtools.enums.EnumConstant;
import java.util.ArrayList;

public abstract class EnumUtils {
    public static <T extends EnumConstant> T[] findAll(Class<T> enumType, String group) {
        ArrayList<EnumConstant> matches = new ArrayList<EnumConstant>();
        for (EnumConstant constant : (EnumConstant[])enumType.getEnumConstants()) {
            if (!constant.getGroup().equals(group)) continue;
            matches.add(constant);
        }
        return (EnumConstant[])matches.toArray();
    }

    public static <T extends EnumConstant> T valueOf(Class<T> enumType, int ordinal) {
        for (EnumConstant constant : (EnumConstant[])enumType.getEnumConstants()) {
            if (ordinal != constant.getValue()) continue;
            return (T)constant;
        }
        throw new IllegalArgumentException("No enum  by ordinal '" + ordinal + "' of " + enumType.getCanonicalName());
    }
}

