/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.event;

import com.github.paganini2008.devtools.event.Event;
import com.github.paganini2008.devtools.event.EventBus;
import com.github.paganini2008.devtools.event.EventSubscriber;
import com.github.paganini2008.devtools.multithreads.ExecutorUtils;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;

public class TestMain {
    private static final AtomicInteger counter = new AtomicInteger();

    public static void main(String[] args) throws Exception {
        int i;
        ExecutorService executor = Executors.newFixedThreadPool(16);
        EventBus<TestEvent, String> eventBus = new EventBus<TestEvent, String>(executor, true, false);
        for (i = 0; i < 5; ++i) {
            eventBus.subscribe(new TestSubcriber("Name_" + i));
        }
        for (i = 0; i < 100000; ++i) {
            eventBus.publish(new TestEvent((Object)eventBus, String.valueOf(i)));
        }
        System.in.read();
        eventBus.close();
        ExecutorUtils.gracefulShutdown(executor, 60000L);
        System.out.println("TestMain.main(): " + counter);
    }

    public static class TestSubcriber
    implements EventSubscriber<TestEvent, String> {
        private final String name;

        public TestSubcriber(String name) {
            this.name = name;
        }

        @Override
        public void onEventFired(TestEvent event) {
            System.out.println("Name: " + this.name + ", Value: " + (String)event.getArgument());
            counter.incrementAndGet();
        }

        @Override
        public boolean isPubSub() {
            return true;
        }
    }

    public static class TestEvent
    extends Event<String> {
        private static final long serialVersionUID = 1L;

        public TestEvent(Object source, String msg) {
            super(source, msg);
        }
    }
}

