/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.http;

import com.github.paganini2008.devtools.StringUtils;
import com.github.paganini2008.devtools.collection.CollectionUtils;
import com.github.paganini2008.devtools.collection.MapUtils;
import com.github.paganini2008.devtools.http.HttpBaseImpl;
import com.github.paganini2008.devtools.http.HttpReponseBody;
import com.github.paganini2008.devtools.http.HttpResponse;
import com.github.paganini2008.devtools.io.IOUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HttpResponseImpl
extends HttpBaseImpl<HttpResponse>
implements HttpResponse,
HttpReponseBody {
    private static final long serialVersionUID = 2657269569071379931L;
    private static final Pattern charsetPattern = Pattern.compile("(?i)\\bcharset=\\s*(?:\"|')?([^\\s,;\"']*)");
    private HttpResponse previous;
    private int statusCode;
    private String statusMessage;
    private String contentType;
    private long length;
    private ByteBuffer byteData;
    private int numRedirects = 0;
    private long elapsedTime;

    HttpResponseImpl() {
    }

    protected HttpResponseImpl(HttpResponse response) {
        this.previous = response;
    }

    @Override
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    public String statusMessage() {
        return this.statusMessage;
    }

    @Override
    public String contentType() {
        return this.contentType;
    }

    @Override
    public long length() {
        return this.length;
    }

    @Override
    public long elapsedTime() {
        return this.elapsedTime;
    }

    @Override
    public void elapsedTime(long time) {
        this.elapsedTime = time;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("URL: ").append(this.url()).append(IOUtils.NEWLINE);
        str.append("StatusCode: ").append(this.statusCode()).append(IOUtils.NEWLINE);
        str.append("StatusMessage: ").append(this.statusMessage()).append(IOUtils.NEWLINE);
        str.append("ContentType: ").append(this.contentType()).append(IOUtils.NEWLINE);
        str.append("Charset: ").append(this.charset()).append(IOUtils.NEWLINE);
        str.append("Length: ").append(this.length()).append(IOUtils.NEWLINE);
        str.append("Headers: ").append(this.headers()).append(IOUtils.NEWLINE);
        str.append("Cookies: ").append(this.cookies()).append(IOUtils.NEWLINE);
        return str.toString();
    }

    @Override
    public String body() {
        if (this.charset == null) {
            this.charset = "UTF-8";
        }
        String body = Charset.forName(this.charset).decode(this.byteData).toString();
        this.byteData.rewind();
        return body;
    }

    @Override
    public byte[] bytes() {
        return this.byteData.array();
    }

    @Override
    public HttpResponse previous() {
        return this.previous;
    }

    @Override
    public int numRedirects() {
        return this.numRedirects;
    }

    @Override
    public void refresh(HttpURLConnection connection) throws IOException {
        this.method = connection.getRequestMethod();
        this.url = connection.getURL();
        this.statusCode = connection.getResponseCode();
        this.statusMessage = connection.getResponseMessage();
        this.contentType = connection.getContentType();
        this.charset = HttpResponseImpl.getCharsetFromContentType(this.contentType);
        Map<String, List<String>> headers = connection.getHeaderFields();
        if (headers != null) {
            this.processResponseHeaders(headers);
        }
        if (this.previous != null) {
            for (Map.Entry<String, String> prevCookie : this.previous.cookies().entrySet()) {
                if (this.hasCookie(prevCookie.getKey())) continue;
                this.cookie(prevCookie.getKey(), prevCookie.getValue());
            }
            this.numRedirects = this.previous.numRedirects() + 1;
        }
    }

    @Override
    public void fillData(ByteBuffer byteData) {
        this.byteData = byteData;
        this.length = byteData.capacity();
    }

    private static String getCharsetFromContentType(String contentType) {
        if (StringUtils.isBlank(contentType)) {
            return null;
        }
        Matcher m = charsetPattern.matcher(contentType);
        if (m.find()) {
            String charset = m.group(1).trim();
            if ((charset = charset.replace("charset=", "")).length() == 0) {
                return null;
            }
            try {
                if (Charset.isSupported(charset)) {
                    return charset;
                }
                if (Charset.isSupported(charset = charset.toUpperCase(Locale.ENGLISH))) {
                    return charset;
                }
            }
            catch (IllegalCharsetNameException e) {
                return null;
            }
        }
        return null;
    }

    private void processResponseHeaders(Map<String, List<String>> headers) {
        for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
            String name = entry.getKey();
            if (StringUtils.isBlank(name)) continue;
            List<String> values = entry.getValue();
            if (name.equalsIgnoreCase("Set-Cookie")) {
                for (String value : values) {
                    if (value == null) continue;
                    Map<String, String> cookieMap = StringUtils.splitAsMap((CharSequence)value, ";", "=");
                    Map.Entry<String, String> first = MapUtils.getFirstEntry(cookieMap);
                    String cookieName = first.getKey();
                    String cookieVal = first.getValue();
                    if (cookieName.length() <= 0) continue;
                    this.cookie(cookieName, cookieVal);
                }
                continue;
            }
            if (!CollectionUtils.isNotEmpty(values)) continue;
            this.header(name, values.get(0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveAs(Writer writer, String charset) throws IOException {
        ByteArrayInputStream in = null;
        try {
            in = new ByteArrayInputStream(this.bytes());
            IOUtils.copy((InputStream)in, writer, charset);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            throw throwable;
        }
        IOUtils.closeQuietly(in);
    }

    @Override
    public void saveAs(OutputStream os) throws IOException {
        ByteArrayInputStream in = null;
        try {
            in = new ByteArrayInputStream(this.bytes());
            IOUtils.copy(in, os);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            throw throwable;
        }
        IOUtils.closeQuietly(in);
    }
}

