/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.io;

import com.github.paganini2008.devtools.MatchMode;
import com.github.paganini2008.devtools.StringUtils;
import com.github.paganini2008.devtools.collection.ListUtils;
import com.github.paganini2008.devtools.collection.MapUtils;
import com.github.paganini2008.devtools.collection.MultiMappedMap;
import com.github.paganini2008.devtools.io.FileUtils;
import com.github.paganini2008.devtools.io.IOUtils;
import com.github.paganini2008.devtools.io.IniConfig;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class BasicIniConfig
implements IniConfig,
Serializable {
    private static final long serialVersionUID = 7872169560893030827L;
    private final MultiMappedMap<String, String, String> config;

    public BasicIniConfig() {
        this(new MultiMappedMap<String, String, String>());
    }

    protected BasicIniConfig(MultiMappedMap<String, String, String> config) {
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFromClassPath(String name, String charset, ClassLoader loader) throws IOException {
        Enumeration<URL> urls = loader == null ? ClassLoader.getSystemResources(name) : loader.getResources(name);
        List<URL> urlList = ListUtils.reverse(urls);
        for (URL url : urlList) {
            BufferedReader br = IOUtils.getBufferedReader(url.openStream(), charset);
            try {
                String line;
                String section = null;
                while (null != (line = br.readLine())) {
                    int index;
                    if (StringUtils.isBlank(line = line.trim()) || (index = line.indexOf("#")) == 0) continue;
                    if (index > 0) {
                        line = line.substring(0, index).trim();
                    }
                    if (line.startsWith("[") && line.endsWith("]") && line.length() > 2) {
                        section = line.substring(1, line.length() - 1);
                        continue;
                    }
                    if (!StringUtils.isNotBlank(section) || (index = line.indexOf("=")) <= 0) continue;
                    this.config.put(section, line.substring(0, index).trim(), line.substring(index + 1).trim());
                }
            }
            finally {
                IOUtils.closeQuietly(br);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(File file, String charset) throws IOException {
        BufferedReader br = null;
        try {
            String line;
            br = FileUtils.getBufferedReader(file, charset);
            String section = null;
            while (null != (line = br.readLine())) {
                int index;
                if (StringUtils.isBlank(line = line.trim()) || (index = line.indexOf("#")) == 0) continue;
                if (index > 0) {
                    line = line.substring(0, index).trim();
                }
                if (line.startsWith("[") && line.endsWith("]") && line.length() > 2) {
                    section = line.substring(1, line.length() - 1);
                    continue;
                }
                if (!StringUtils.isNotBlank(section) || (index = line.indexOf("=")) <= 0) continue;
                this.config.put(section, line.substring(0, index).trim(), line.substring(index + 1).trim());
            }
        }
        finally {
            IOUtils.closeQuietly(br);
        }
    }

    @Override
    public String[] sections() {
        return this.config.keySet().toArray(new String[0]);
    }

    @Override
    public Map<String, String> get(String section) {
        return new HashMap<String, String>((Map<String, String>)this.config.get(section));
    }

    @Override
    public Map<String, String> get(String section, String substr, MatchMode mode) {
        return MapUtils.toMatchedKeyMap(this.get(section), substr, mode);
    }

    @Override
    public String set(String section, String name, String value) {
        return this.config.put(section, name, value);
    }

    @Override
    public Map<String, String> set(String section, Map<String, String> kwargs) {
        return this.config.put(section, kwargs);
    }

    @Override
    public String getString(String section, String name) {
        return this.getString(section, name, null);
    }

    @Override
    public String getString(String section, String name, String defaultValue) {
        return this.config.get(section, name, defaultValue);
    }

    @Override
    public Byte getByte(String section, String name) {
        return this.getByte(section, name, null);
    }

    @Override
    public Byte getByte(String section, String name, Byte defaultValue) {
        return MapUtils.get(this.config.get(section), name, Byte.class, defaultValue);
    }

    @Override
    public Short getShort(String section, String name) {
        return this.getShort(section, name, null);
    }

    @Override
    public Short getShort(String section, String name, Short defaultValue) {
        return MapUtils.get(this.config.get(section), name, Short.class, defaultValue);
    }

    @Override
    public Integer getInteger(String section, String name) {
        return this.getInteger(section, name, null);
    }

    @Override
    public Integer getInteger(String section, String name, Integer defaultValue) {
        return MapUtils.get(this.config.get(section), name, Integer.class, defaultValue);
    }

    @Override
    public Long getLong(String section, String name) {
        return this.getLong(section, name, null);
    }

    @Override
    public Long getLong(String section, String name, Long defaultValue) {
        return MapUtils.get(this.config.get(section), name, Long.class, defaultValue);
    }

    @Override
    public Float getFloat(String section, String name) {
        return this.getFloat(section, name, null);
    }

    @Override
    public Float getFloat(String section, String name, Float defaultValue) {
        return MapUtils.get(this.config.get(section), name, Float.class, defaultValue);
    }

    @Override
    public Double getDouble(String section, String name) {
        return this.getDouble(section, name, null);
    }

    @Override
    public Double getDouble(String section, String name, Double defaultValue) {
        return MapUtils.get(this.config.get(section), name, Double.class, defaultValue);
    }

    @Override
    public Boolean getBoolean(String section, String name) {
        return this.getBoolean(section, name, null);
    }

    @Override
    public Boolean getBoolean(String section, String name, Boolean defaultValue) {
        return MapUtils.get(this.config.get(section), name, Boolean.class, defaultValue);
    }

    @Override
    public Map<String, Map<String, String>> toMap() {
        return new LinkedHashMap<String, Map<String, String>>(this.config);
    }

    @Override
    public Iterator<String> iterator() {
        return this.config.keySet().iterator();
    }

    public String toString() {
        return this.config.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(File file, String charset) throws IOException {
        FileOutputStream output = null;
        try {
            output = FileUtils.openOutputStream(file);
            this.store(output, charset);
        }
        finally {
            IOUtils.closeQuietly(output);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void store(OutputStream os, String charset) throws IOException {
        BufferedWriter bw = null;
        try {
            bw = IOUtils.getBufferedWriter(os, charset);
            for (String section : this.sections()) {
                bw.write("[" + section + "]");
                bw.newLine();
                for (Map.Entry inner : this.config.get(section).entrySet()) {
                    bw.write((String)inner.getKey() + "=" + (String)inner.getValue());
                    bw.newLine();
                }
            }
        }
        finally {
            IOUtils.flushQuietly(bw);
        }
    }
}

