/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.io;

import com.github.paganini2008.devtools.Assert;
import com.github.paganini2008.devtools.StringUtils;
import com.github.paganini2008.devtools.io.Handler;
import com.github.paganini2008.devtools.io.PathUtils;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ClassFinder {
    private static final ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
    private static final String classPath;
    private static final int classPathCharLength;

    public static void lookup(String packageName, boolean recursive, Handler handler) throws IOException {
        Assert.hasNoText("Please set package name.");
        ClassLoader classLoader = currentClassLoader;
        String packagePath = packageName.replace(".", "/");
        URL url = classLoader.getResource(packagePath);
        if (url != null) {
            String type = url.getProtocol();
            String path = url.getPath();
            if (type.equals("file")) {
                ClassFinder.lookupFromProject(path, recursive, handler);
            } else if (type.equals("jar")) {
                ClassFinder.lookupFromJar(path, recursive, handler);
            }
        }
    }

    private static void lookupFromProject(String filePath, boolean recursive, Handler handler) {
        File file = new File(filePath = filePath.replace("%20", " "));
        File[] childFiles = file.listFiles();
        if (childFiles != null) {
            ArrayList<File> fileList = new ArrayList<File>(Arrays.asList(childFiles));
            Collections.sort(fileList, new Comparator<File>(){

                @Override
                public int compare(File left, File right) {
                    return right.getName().compareTo(left.getName());
                }
            });
            String currentName = null;
            for (File childFile : fileList) {
                if (childFile.isDirectory()) {
                    if (!recursive) continue;
                    ClassFinder.lookupFromProject(childFile.getPath(), recursive, handler);
                    continue;
                }
                if (!childFile.getName().endsWith(".class")) continue;
                String path = childFile.getPath().replace("\\", "/");
                String fullName = path.substring(path.indexOf(classPath) + classPathCharLength, path.lastIndexOf("."));
                String simpleName = fullName.substring(fullName.lastIndexOf("/") + 1);
                if (currentName != null && simpleName.startsWith(currentName)) {
                    int index = simpleName.indexOf("$");
                    if (index != -1) {
                        try {
                            Integer.parseInt(simpleName.substring(index + 1));
                            continue;
                        }
                        catch (RuntimeException runtimeException) {}
                    }
                } else {
                    currentName = simpleName;
                }
                if (handler == null) continue;
                String fileName = path.substring(path.indexOf(classPath) + classPathCharLength - 1);
                handler.publish(fileName, fullName.replace("/", "."));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void lookupFromJar(String jarPath, boolean recursive, Handler handler) throws IOException {
        String[] jarInfo = jarPath.split("!");
        String jarFilePath = jarInfo[0].substring(jarInfo[0].indexOf("/"));
        String packagePath = jarInfo[1].substring(1);
        try (JarFile jarFile = new JarFile(jarFilePath);){
            Enumeration<JarEntry> entrys = jarFile.entries();
            while (entrys.hasMoreElements()) {
                JarEntry jarEntry = entrys.nextElement();
                String entryName = jarEntry.getName();
                if (!entryName.endsWith(".class")) continue;
                String fileName = null;
                if (recursive) {
                    if (entryName.startsWith(packagePath)) {
                        fileName = entryName;
                    }
                } else {
                    int index = entryName.lastIndexOf("/");
                    String myPackagePath = index != -1 ? entryName.substring(0, index) : entryName;
                    if (myPackagePath.equals(packagePath)) {
                        fileName = entryName;
                    }
                }
                if (handler == null || !StringUtils.isNotBlank(fileName)) continue;
                String className = fileName.replace("/", ".").substring(0, entryName.lastIndexOf("."));
                handler.publish(fileName, className);
            }
        }
    }

    private ClassFinder() {
    }

    public static void main(String[] args) throws Exception {
        String packageName = "lazycat.concurrent";
        ClassFinder.lookup(packageName, true, new Handler(){

            @Override
            public void publish(String fileName, String className) {
                System.out.println(fileName + ": " + className);
            }
        });
    }

    static {
        String path = currentClassLoader.getResource("").getPath().replace("\\", "/");
        if (PathUtils.isWindowsOS()) {
            path = path.substring(1);
        }
        classPath = path;
        classPathCharLength = classPath.length();
    }
}

