/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.io;

import com.github.paganini2008.devtools.io.BasicIniConfig;
import com.github.paganini2008.devtools.io.IniConfig;
import com.github.paganini2008.devtools.io.RefreshingIniConfig;
import java.io.IOException;

public class ClassPathIniConfig
extends RefreshingIniConfig {
    private static final long serialVersionUID = -4691878287460797044L;
    private final String[] names;
    private final ClassLoader loader;
    private String charset = "UTF-8";

    public ClassPathIniConfig(String ... names) {
        this(names, ClassPathIniConfig.class.getClassLoader());
    }

    public ClassPathIniConfig(String[] names, ClassLoader loader) {
        this.names = names;
        this.loader = loader;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    @Override
    protected IniConfig getConfig() throws IOException {
        BasicIniConfig config = new BasicIniConfig();
        if (this.names != null && this.names.length > 0) {
            for (String name : this.names) {
                config.loadFromClassPath(name, this.charset, this.loader);
            }
        }
        return config;
    }
}

