/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.io;

import com.github.paganini2008.devtools.collection.MapUtils;
import com.github.paganini2008.devtools.io.BasicProperties;
import com.github.paganini2008.devtools.io.RefreshingResource;
import java.io.IOException;
import java.util.Map;

public class ClassPathResource
extends RefreshingResource {
    private static final long serialVersionUID = -4336490159044412458L;
    private final String[] names;
    private final ClassLoader loader;
    private String charset = "UTF-8";

    public ClassPathResource(String ... names) {
        this(names, ClassPathResource.class.getClassLoader());
    }

    public ClassPathResource(String[] names, ClassLoader loader) {
        this.names = names;
        this.loader = loader;
    }

    @Override
    protected Map<String, String> getConfig() throws IOException {
        BasicProperties p = new BasicProperties();
        if (this.names != null && this.names.length > 0) {
            for (String name : this.names) {
                p.load(name, this.charset, this.loader);
            }
        }
        return MapUtils.toMap(p);
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }
}

