/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.io;

import com.github.paganini2008.devtools.ArrayUtils;
import com.github.paganini2008.devtools.MatchMode;
import com.github.paganini2008.devtools.StringUtils;
import com.github.paganini2008.devtools.io.DefaultTreeMatcher;
import java.io.File;

public class DirectoryTreeMatcher
extends DefaultTreeMatcher {
    private final String[] includedFiles;
    private final String[] excludedFiles;
    private final MatchMode matchMode;

    public DirectoryTreeMatcher() {
        this(StringUtils.EMPTY_ARRAY, StringUtils.EMPTY_ARRAY, MatchMode.ANY_WHERE);
    }

    public DirectoryTreeMatcher(String includedFile, String excludedFile, MatchMode matchMode) {
        String[] stringArray;
        String[] stringArray2;
        if (StringUtils.isNotBlank(includedFile)) {
            String[] stringArray3 = new String[1];
            stringArray2 = stringArray3;
            stringArray3[0] = includedFile;
        } else {
            stringArray2 = StringUtils.EMPTY_ARRAY;
        }
        if (StringUtils.isNotBlank(excludedFile)) {
            String[] stringArray4 = new String[1];
            stringArray = stringArray4;
            stringArray4[0] = excludedFile;
        } else {
            stringArray = StringUtils.EMPTY_ARRAY;
        }
        this(stringArray2, stringArray, matchMode);
    }

    public DirectoryTreeMatcher(String[] includedFiles, String[] excludedFiles, MatchMode matchMode) {
        this.includedFiles = includedFiles;
        this.excludedFiles = excludedFiles;
        this.matchMode = matchMode;
    }

    @Override
    public boolean matchDirectory(File directory, int depth, boolean hasLast) {
        boolean match = true;
        if (ArrayUtils.isNotEmpty(this.includedFiles)) {
            match = false;
            for (String pattern : this.includedFiles) {
                if (!this.matchMode.matches(pattern, directory.getAbsolutePath())) continue;
                match = true;
                break;
            }
        }
        if (ArrayUtils.isNotEmpty(this.excludedFiles)) {
            for (String pattern : this.excludedFiles) {
                if (!this.matchMode.matches(pattern, directory.getAbsolutePath())) continue;
                match = false;
                break;
            }
        }
        return match;
    }

    @Override
    public boolean matchFile(File directory, int depth, File file, boolean hasLast) {
        return false;
    }
}

