/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.io;

import com.github.paganini2008.devtools.io.Directory;
import com.github.paganini2008.devtools.io.DirectoryFilter;
import com.github.paganini2008.devtools.io.DirectoryWalkerHandler;
import com.github.paganini2008.devtools.io.ForkJoinDirectoryWalker;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

public abstract class FileSearchUtils {
    public static File[] search(File directory, final DirectoryFilter fileInfoFilter, int nThreads, int maxDepth) {
        final ArrayList files = new ArrayList();
        ForkJoinDirectoryWalker directoryWalker = new ForkJoinDirectoryWalker(directory, new DirectoryWalkerHandler(){

            @Override
            public void handleDirectoryEnd(File file, Directory directory, int depth) throws IOException {
                if (fileInfoFilter.accept(directory)) {
                    files.add(file);
                }
            }

            @Override
            public void handleFile(File file, int depth) throws Exception {
                if (fileInfoFilter.accept(file)) {
                    files.add(file);
                }
            }
        });
        directoryWalker.setThreadCount(nThreads);
        directoryWalker.setMaxDepth(maxDepth);
        directoryWalker.walk();
        return files.toArray(new File[0]);
    }

    public static void main(String[] args) {
        File[] files;
        File directory = new File("d:/sql");
        for (File file : files = FileSearchUtils.search(directory, new DirectoryFilter(){

            @Override
            public boolean accept(Directory fileInfo) {
                return fileInfo.getLength() > 0x3200000L;
            }
        }, 8, 5)) {
            System.out.println(file);
        }
    }
}

