/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.io;

import com.github.paganini2008.devtools.NumberUtils;
import com.github.paganini2008.devtools.io.AbstractDirectoryWalker;
import com.github.paganini2008.devtools.io.Directory;
import com.github.paganini2008.devtools.io.DirectoryWalker;
import com.github.paganini2008.devtools.io.DirectoryWalkerHandler;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.RecursiveTask;

public class ForkJoinDirectoryWalker
extends AbstractDirectoryWalker {
    private int maxDepth = -1;
    private FileFilter fileFilter;
    private final DirectoryWalkerHandler handler;

    public ForkJoinDirectoryWalker(File directory, DirectoryWalkerHandler handler) {
        super(directory);
        this.handler = handler;
    }

    public void setMaxDepth(int maxDepth) {
        this.maxDepth = maxDepth;
    }

    public void setFileFilter(FileFilter fileFilter) {
        this.fileFilter = fileFilter;
    }

    @Override
    protected final void walk(Executor threadPool, File root, DirectoryWalker.FileInfo rootInfo, int depth, DirectoryWalker.ProgressBar progressBar) {
        DirectoryWalkTask task = new DirectoryWalkTask(root, rootInfo, depth, progressBar);
        ForkJoinTask<DirectoryWalker.FileInfo> future = ((ForkJoinPool)threadPool).submit(task);
        try {
            future.get();
        }
        catch (Exception e) {
            this.handler.handleDirectoryOnError(root, depth, e);
        }
    }

    @Override
    protected ForkJoinPool getThreadPool(int nThreads) {
        return new ForkJoinPool(nThreads);
    }

    public static void main(String[] args) throws Exception {
        File directory = new File("E:\\work\\repo_latest\\nexus-3.0");
        ForkJoinDirectoryWalker walker = new ForkJoinDirectoryWalker(directory, new DirectoryWalkerHandler(){

            @Override
            public void handleFile(File file, int depth) throws Exception {
                if (file.getName().endsWith(".jar")) {
                    System.out.println(file);
                }
            }
        });
        walker.setProgressable(new DirectoryWalker.Progressable(){

            @Override
            public void progress(int fileCount, int folderCount, long length, float completedRatio, long elapsed) {
                System.out.println("fileCount: " + fileCount + ", folderCount: " + folderCount + ", length: " + length + ", completedRatio: " + NumberUtils.format((Number)Float.valueOf(completedRatio), "0.00%") + ", elapsed: " + elapsed);
            }
        });
        Directory fileInfo = walker.walk();
        System.out.println(fileInfo.getLength());
        System.out.println("DirectoryWalker.main()");
        System.in.read();
        System.out.println("Completed.");
    }

    private class DirectoryWalkTask
    extends RecursiveTask<DirectoryWalker.FileInfo> {
        private static final long serialVersionUID = -1911846799071310358L;
        private final File directory;
        private final DirectoryWalker.FileInfo directoryInfo;
        private final int depth;
        private final DirectoryWalker.ProgressBar progressBar;

        DirectoryWalkTask(File directory, DirectoryWalker.FileInfo directoryInfo, int depth, DirectoryWalker.ProgressBar progressBar) {
            this.directory = directory;
            this.directoryInfo = directoryInfo;
            this.depth = depth;
            this.progressBar = progressBar;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected DirectoryWalker.FileInfo compute() {
            block15: {
                try {
                    if (!ForkJoinDirectoryWalker.this.handler.shouldHandleDirectory(this.directory, this.depth)) break block15;
                    ForkJoinDirectoryWalker.this.handler.handleDirectoryStart(this.directory, this.depth);
                    if (ForkJoinDirectoryWalker.this.maxDepth < 0 || this.depth <= ForkJoinDirectoryWalker.this.maxDepth) {
                        File[] childFiles;
                        File[] fileArray = childFiles = ForkJoinDirectoryWalker.this.fileFilter != null ? this.directory.listFiles(ForkJoinDirectoryWalker.this.fileFilter) : this.directory.listFiles();
                        if (childFiles != null) {
                            for (File childFile : childFiles) {
                                block16: {
                                    if (this.progressBar.isCancelled()) {
                                        throw new CancellationException();
                                    }
                                    this.progressBar.processBegin(childFile);
                                    this.directoryInfo.process(childFile);
                                    if (childFile.isDirectory()) {
                                        DirectoryWalker.FileInfo childFileInfo = this.directoryInfo.newChildFileInfo(childFile);
                                        DirectoryWalkTask task = new DirectoryWalkTask(childFile, childFileInfo, this.depth + 1, this.progressBar);
                                        task.fork();
                                        task.join();
                                    } else if (ForkJoinDirectoryWalker.this.handler.shouldHandleFile(childFile, this.depth)) {
                                        try {
                                            ForkJoinDirectoryWalker.this.handler.handleFile(childFile, this.depth);
                                        }
                                        catch (Exception e) {
                                            if (ForkJoinDirectoryWalker.this.handler.handleFileOnError(childFile, this.depth, e)) break block16;
                                            this.progressBar.cancel();
                                        }
                                    }
                                }
                                this.progressBar.processEnd(childFile);
                            }
                        }
                    }
                    ForkJoinDirectoryWalker.this.handler.handleDirectoryEnd(this.directory, this.directoryInfo, this.depth);
                }
                catch (IOException e) {
                    if (!ForkJoinDirectoryWalker.this.handler.handleDirectoryOnError(this.directory, this.depth, e)) {
                        this.progressBar.cancel();
                    }
                }
                finally {
                    this.directoryInfo.done();
                }
            }
            return this.directoryInfo;
        }
    }
}

