/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.io;

import com.github.paganini2008.devtools.CharsetUtils;
import com.github.paganini2008.devtools.io.FileUtils;
import com.github.paganini2008.devtools.io.IOUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class LineIterator
implements Iterator<String> {
    private final BufferedReader br;
    private String cachedLine;
    private boolean finished = false;

    public LineIterator(File input, String charset) throws IOException {
        this(FileUtils.openInputStream(input), charset);
    }

    public LineIterator(InputStream ins, String charset) {
        this(IOUtils.getBufferedReader(ins, CharsetUtils.toCharset(charset)));
    }

    public LineIterator(Reader reader) {
        this.br = IOUtils.getBufferedReader(reader);
    }

    @Override
    public boolean hasNext() {
        if (this.cachedLine != null) {
            return true;
        }
        if (this.finished) {
            return false;
        }
        try {
            String line;
            do {
                if ((line = this.br.readLine()) != null) continue;
                this.finished = true;
                return false;
            } while (!this.isValid(line));
            this.cachedLine = line;
            return true;
        }
        catch (IOException ioe) {
            this.close();
            throw new IllegalStateException(ioe);
        }
    }

    protected boolean isValid(String line) {
        return true;
    }

    @Override
    public String next() {
        return this.nextLine();
    }

    public String nextLine() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more lines.");
        }
        String currentLine = this.cachedLine;
        this.cachedLine = null;
        return currentLine;
    }

    public void close() {
        this.finished = true;
        IOUtils.closeQuietly(this.br);
        this.cachedLine = null;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove unsupported on LineIterator");
    }
}

