/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.io;

import com.github.paganini2008.devtools.CharsetUtils;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class LineReader
implements Iterator<List<String>> {
    private final RandomAccessFile raf;
    private final int rows;
    private long offset;
    private Charset charset = CharsetUtils.UTF_8;

    public LineReader(File file, int rows) throws IOException {
        this.raf = new RandomAccessFile(file, "r");
        this.offset = this.raf.getFilePointer();
        this.rows = rows;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    @Override
    public boolean hasNext() {
        try {
            String line = this.raf.readLine();
            this.raf.seek(this.offset);
            return line != null;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public List<String> next() {
        ArrayList<String> lines = new ArrayList<String>();
        int row = 0;
        try {
            String line;
            while (row++ < this.rows && null != (line = this.raf.readLine())) {
                lines.add(new String(line.getBytes("ISO-8859-1"), this.charset));
            }
            this.offset = this.raf.getFilePointer();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return lines;
    }

    public void close() {
        try {
            this.raf.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public static void main(String[] args) throws Exception {
        LineReader reader = new LineReader(new File("d:/company_status.txt"), 10);
        while (reader.hasNext()) {
            Object lines = reader.next();
            Iterator iterator = lines.iterator();
            while (iterator.hasNext()) {
                String line = (String)iterator.next();
                System.out.println(line);
            }
            System.out.println("----------------------------------");
        }
        reader.close();
    }
}

