/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.io;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;

public class LineWriter
extends BufferedWriter {
    private final AtomicInteger rows = new AtomicInteger(0);
    private final List<String> queue = new CopyOnWriteArrayList<String>();
    private final int batchSize;

    public LineWriter(Writer out) throws IOException {
        this(out, 10);
    }

    public LineWriter(Writer out, int batchSize) {
        super(out);
        this.batchSize = batchSize;
    }

    @Override
    public void write(String str) throws IOException {
        this.queue.add(str);
        if (this.rows.incrementAndGet() > this.batchSize) {
            this.doWrite();
        }
    }

    @Override
    public void flush() throws IOException {
        this.doWrite();
        super.flush();
    }

    private void doWrite() throws IOException {
        for (String line : this.queue) {
            super.write(line);
            super.newLine();
            this.queue.remove(line);
        }
    }
}

